/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.VFSIOException;
import org.jboss.fresh.vfs.impl.SecureVFS;

public class VFSOutputStream
extends OutputStream {
    private SecureVFS vfs;
    private FileName filename;
    private boolean append;
    private boolean closed;
    private boolean first = true;
    private String tag;
    private byte[] buff;
    private int tlen;
    private static Logger log = Logger.getLogger((String)"org.jboss.fresh.vfs.impl.VFSOutputStream");

    public VFSOutputStream(SecureVFS vfs, String filename) throws IOException {
        this(vfs, filename, false);
    }

    public VFSOutputStream(SecureVFS vfs, String fname, boolean append) throws IOException {
        try {
            this.vfs = vfs;
            this.filename = new FileName(fname);
            this.append = append;
            FileInfo info = vfs.getFileInfo(this.filename, false);
            log.debug((Object)("/vfs/io <init> info: " + info));
            if (info == null) {
                info = new FileInfo(this.filename, 1);
                info.setMime("x-application/octet-stream");
                log.debug((Object)("/vfs/io<init> info: " + info));
                log.debug((Object)("/vfs/iocreating file... " + info.getFileName()));
                log.debug((Object)("/vfs/iocreating file with path " + info.getFileName().getPath()));
                this.tag = vfs.createFile(info);
                log.debug((Object)("/vfs/iofile created: " + this.tag));
            } else {
                this.tag = info.getTag();
            }
        }
        catch (Throwable ex) {
            throw new VFSIOException(ex);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
    }

    public void flush() throws IOException {
        try {
            byte[] bf;
            if (this.tlen == 0) {
                return;
            }
            FileOpInfo inf = new FileOpInfo();
            inf.tag = this.tag;
            inf.filename = this.filename;
            if (this.first && !this.append) {
                inf.append = false;
                this.first = false;
            } else {
                inf.append = true;
            }
            inf.complete = this.closed;
            if (this.tlen != this.buff.length) {
                bf = new byte[this.tlen];
                System.arraycopy(this.buff, 0, bf, 0, this.tlen);
            } else {
                bf = this.buff;
            }
            inf.buf = bf;
            FileWriteInfo retinf = this.vfs.write(inf);
            this.tag = retinf.tag;
            this.tlen = 0;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new VFSIOException(ex);
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.flush();
        if (this.buff == null || this.buff.length < len) {
            int sz = buf.length > len ? buf.length : len;
            this.buff = new byte[sz];
        }
        System.arraycopy(buf, off, this.buff, 0, len);
        this.tlen = len;
    }
}

