/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.disk;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSMetaCacheUpdater;

public class DiskVFSMeta
implements VFSMeta {
    private String rootpath;
    private FileName root;
    private File fsroot;
    private VFSMetaCacheUpdater cup;
    private int rootlen;
    private HashMap tags = new HashMap();
    private static Logger log = Logger.getLogger(DiskVFSMeta.class);

    public DiskVFSMeta(String rootpath) throws Exception {
        this.fsroot = new File(rootpath);
        String rp = this.fsroot.getPath();
        int n = this.rootlen = rp.endsWith("/") ? rp.length() - 1 : rp.length();
        if (!this.fsroot.isDirectory()) {
            throw new RuntimeException("Root directory does not exist: " + rootpath);
        }
        this.root = new FileName("/");
    }

    public void setCacheUpdater(VFSMetaCacheUpdater updater) {
        this.cup = updater;
    }

    public VFSMetaCacheUpdater getCacheUpdater() {
        return this.cup;
    }

    private FileInfo fileToFileInfo(File file) throws VFSException {
        try {
            FileInfo inf = new FileInfo(file.getPath().substring(this.rootlen));
            inf.setCreateDate(new Date(file.lastModified()));
            inf.setFileType(file.isFile() ? 1 : 2);
            inf.setLastModified(new Date(file.lastModified()));
            inf.setLength(file.length());
            inf.setMime("application/octet-stream");
            String tag = (String)this.tags.get(file);
            inf.setTag(tag == null ? String.valueOf(inf.getLastModified().getTime()) : tag);
            return inf;
        }
        catch (IOException ex) {
            log.info((Object)"Exception while getting file information: ", (Throwable)ex);
            return null;
        }
    }

    public boolean exists(FileName name) throws Exception {
        FileName adjusted = this.root.absolutize(name);
        File thefile = new File(this.fsroot, adjusted.toString());
        return thefile.exists();
    }

    public int countChildren(FileName path) throws Exception {
        FileName adjusted = this.root.absolutize(path);
        File thefile = new File(this.fsroot, adjusted.toString());
        return thefile.list().length;
    }

    public List resolvePath(FileName path) throws Exception {
        LinkedList<FileName> ls = new LinkedList<FileName>();
        if (path == null) {
            ls.add(new FileName("/"));
            return ls;
        }
        FileName adjusted = this.root.absolutize(path);
        File thefile = new File(this.fsroot, adjusted.toString());
        ls.add(new FileName(thefile.getPath().substring(this.rootlen)));
        return ls;
    }

    public FileInfo getFileInfo(FileName name) throws Exception {
        FileName adjusted = this.root.absolutize(name);
        File thefile = new File(this.fsroot, adjusted.toString());
        return this.fileToFileInfo(thefile);
    }

    public List list(FileName path) throws Exception {
        FileName adjusted = this.root.absolutize(path);
        File thefile = new File(this.fsroot, adjusted.toString());
        File[] fs = thefile.listFiles();
        LinkedList<FileInfo> l = new LinkedList<FileInfo>();
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            l.add(this.fileToFileInfo(f));
        }
        return l;
    }

    public Collection getLinks(FileName target) throws Exception {
        throw new RuntimeException("Not implemented");
    }

    public void create(FileInfo fi) throws Exception {
        FileName adjusted = this.root.absolutize(fi.getFileName().toString());
        File thefile = new File(this.fsroot, adjusted.toString());
        this.tags.put(thefile, fi.getTag());
        if (fi.getFileType() == 2) {
            if (thefile.isDirectory()) {
                throw new VFSException("Directory exists already: " + fi.getFileName());
            }
            if (thefile.exists()) {
                throw new VFSException("File exists already (is not a directory): " + fi.getFileName());
            }
            if (!thefile.mkdir()) {
                throw new VFSException("Could not create directory: " + fi.getFileName());
            }
        } else if (!thefile.createNewFile()) {
            throw new VFSException("Could not create file: " + fi.getFileName());
        }
    }

    public void update(FileInfo fi) throws Exception {
        FileName adjusted = this.root.absolutize(fi.getFileName().toString());
        File thefile = new File(this.fsroot, adjusted.toString());
        this.tags.put(thefile, fi.getTag());
    }

    public void remove(FileName name) throws Exception {
        FileName adjusted = this.root.absolutize(name.toString());
        File thefile = new File(this.fsroot, adjusted.toString());
        if (!thefile.exists()) {
            throw new VFSException("File does not exist: " + name);
        }
        if (!thefile.delete()) {
            throw new VFSException("File could no be deleted: " + name);
        }
    }

    public void rename(FileName oldPath, FileName newPath) throws Exception {
        FileName adjusted = this.root.absolutize(oldPath.toString());
        File thefile = new File(this.fsroot, adjusted.toString());
        if (!thefile.exists()) {
            throw new VFSException("File does not exist: " + oldPath);
        }
        FileName adjNu = this.root.absolutize(newPath.toString());
        File newFile = new File(this.fsroot, adjNu.toString());
        thefile.renameTo(newFile);
    }

    public float moveBefore(FileName currFile, FileName nextFile) throws Exception {
        throw new RuntimeException("Method not implemented");
    }
}

