/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.disk;

import java.io.File;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.jboss.fresh.vfs.VFSStoreCacheUpdater;

public class DiskVFSStore
implements VFSStore {
    private VFSMeta meta;
    private VFSStoreCacheUpdater cup;
    private FileName root;
    private File fsroot;
    private static Logger log = Logger.getLogger(DiskVFSStore.class);

    public DiskVFSStore(VFSMeta meta, String rootpath) throws Exception {
        this.meta = meta;
        this.fsroot = new File(rootpath);
        this.root = new FileName("/");
    }

    public void setCacheUpdater(VFSStoreCacheUpdater updater) {
        this.cup = updater;
    }

    public VFSStoreCacheUpdater getCacheUpdater() {
        return this.cup;
    }

    public boolean hasContent(FileName filename) throws Exception {
        FileName adjusted = this.root.absolutize(filename);
        File thefile = new File(this.fsroot, adjusted.toString());
        return thefile.length() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(FileOpInfo info) throws Exception {
        FileName adjusted = this.root.absolutize(info.filename);
        File thefile = new File(this.fsroot, adjusted.toString());
        RandomAccessFile raf = new RandomAccessFile(thefile, "rw");
        try {
            if (!info.append) {
                raf.setLength(0L);
            } else {
                raf.seek(info.offset);
            }
            raf.write(info.buf);
        }
        finally {
            raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileReadInfo readContent(FileOpInfo info) throws Exception {
        FileName adjusted = this.root.absolutize(info.filename);
        File thefile = new File(this.fsroot, adjusted.toString());
        RandomAccessFile raf = new RandomAccessFile(thefile, "r");
        try {
            boolean more;
            int free = (int)(raf.length() - info.offset);
            if (free <= 0) {
                throw new VFSException("Trying to read beyond the end of file");
            }
            raf.seek(info.offset);
            int bufsize = 8192;
            boolean bl = more = free > bufsize;
            if (free < bufsize) {
                bufsize = free;
            }
            FileReadInfo ri = new FileReadInfo();
            ri.buf = new byte[bufsize];
            int rc = raf.read(ri.buf);
            if (rc != ri.buf.length) {
                byte[] nubuf = new byte[rc];
                System.arraycopy(ri.buf, 0, nubuf, 0, rc);
                ri.buf = nubuf;
            }
            ri.tag = String.valueOf(raf.length());
            ri.more = more;
            FileReadInfo fileReadInfo = ri;
            return fileReadInfo;
        }
        finally {
            raf.close();
        }
    }

    public void removeContent(FileName name) throws Exception {
        FileName adjusted = this.root.absolutize(name);
        File thefile = new File(this.fsroot, adjusted.toString());
        if (thefile.exists() && !thefile.delete()) {
            throw new VFSException("Could not delete: " + name);
        }
    }

    public void rename(FileName oldPath, FileName newPath) throws Exception {
        FileName adjDest;
        File destFile;
        FileName adjusted = this.root.absolutize(oldPath);
        File thefile = new File(this.fsroot, adjusted.toString());
        if (!thefile.renameTo(destFile = new File(this.fsroot, (adjDest = this.root.absolutize(newPath)).toString()))) {
            throw new VFSException("Could not move " + oldPath + " to " + newPath);
        }
    }
}

