/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.fresh.vfs.impl.mem.FileContent;
import org.jboss.fresh.vfs.impl.mem.MemInputStream;
import org.jboss.fresh.vfs.impl.mem.MemOutputStream;
import org.jboss.fresh.vfs.impl.mem.RAF;

public class MemFile
implements FileContent {
    private static final int BUF_SIZE = 4096;
    private int len = 0;
    private ArrayList buffers = new ArrayList();
    private byte[] BBUF = new byte[1];

    public InputStream getInputStream() {
        return new MemInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new MemOutputStream(this);
    }

    public long getLength() {
        return this.len;
    }

    public void setLength(long len) {
        this.len = (int)len;
    }

    public RAF getRAF() {
        return new RAF(this);
    }

    public void write(int pos, int val) {
        this.BBUF[0] = (byte)val;
        this.write(pos, this.BBUF, 0, 1);
    }

    public void write(int pos, byte[] buf, int offs, int len) {
        int idx = this.getBufferForOffset(pos);
        if (idx == -1) {
            byte[] bf = new byte[len];
            System.arraycopy(buf, offs, bf, 0, len);
            this.buffers.add(new ByteBuffer(pos, len, bf));
            offs += len;
            this.len += len;
        } else {
            ByteBuffer bb = (ByteBuffer)this.buffers.get(idx++);
            int inpos = pos - bb.ofs;
            int btogo = bb.buf.length - inpos;
            int avail = buf.length - offs;
            if (btogo > avail) {
                btogo = avail;
            }
            while (len > 0) {
                if (btogo <= 0) {
                    if (idx < this.buffers.size()) {
                        bb = (ByteBuffer)this.buffers.get(idx++);
                        inpos = pos - bb.ofs;
                        btogo = bb.buf.length - inpos;
                    } else {
                        btogo = len > 4096 ? len : 4096;
                        bb = new ByteBuffer(pos, 0, new byte[btogo]);
                        inpos = 0;
                    }
                }
                if (offs < 0 || offs >= buf.length) {
                    System.out.println("DOUGH !!!");
                } else if (inpos < 0 || inpos >= bb.buf.length) {
                    System.out.println("DOUGH !!!");
                } else if (btogo > bb.buf.length - inpos) {
                    System.out.println("DOUGH !!!");
                } else if (btogo > buf.length - offs) {
                    System.out.println("DOUGH !!!");
                }
                System.arraycopy(buf, offs, bb.buf, inpos, btogo);
                bb.size = btogo;
                len -= btogo;
                offs += btogo;
                pos += btogo;
                this.len += btogo;
            }
        }
    }

    public int read(int pos) {
        int rc = this.read(pos, this.BBUF, 0, 1);
        if (rc == -1) {
            return rc;
        }
        return this.BBUF[0];
    }

    public int read(int pos, byte[] buf, int offs, int len) {
        int idx = this.getBufferForOffset(pos);
        if (idx == -1) {
            return -1;
        }
        ByteBuffer bb = (ByteBuffer)this.buffers.get(idx++);
        int inpos = pos - bb.ofs;
        int btogo = bb.size - inpos;
        if (btogo <= 0) {
            return -1;
        }
        int oldoffs = pos;
        while (len > 0) {
            btogo = btogo < len ? btogo : len;
            System.arraycopy(bb.buf, inpos, buf, offs, btogo);
            offs += btogo;
            pos += btogo;
            if ((len -= btogo) > 0 && idx < this.buffers.size()) {
                bb = (ByteBuffer)this.buffers.get(idx);
                btogo = bb.size;
                continue;
            }
            return pos - oldoffs;
        }
        return len;
    }

    int getBufferForOffset(int ofs) {
        ByteBuffer bb;
        Iterator it = this.buffers.iterator();
        int i = 0;
        while (it.hasNext()) {
            bb = (ByteBuffer)it.next();
            if (bb.ofs > ofs) {
                return i - 1;
            }
            if (bb.ofs == ofs) {
                return i;
            }
            ++i;
        }
        if (this.buffers.size() > 0) {
            int last = this.buffers.size() - 1;
            bb = (ByteBuffer)this.buffers.get(last);
            if (bb.size < bb.buf.length) {
                return last;
            }
        }
        return -1;
    }

    public void close() {
    }

    public void truncate(long size) {
        int lesize;
        int idx = this.getBufferForOffset((int)size);
        if (idx == -1) {
            return;
        }
        while (this.buffers.size() > idx + 1) {
            this.buffers.remove(this.buffers.size() - 1);
        }
        ByteBuffer bb = (ByteBuffer)this.buffers.get(idx);
        bb.size = lesize = (int)size - bb.ofs;
        if (lesize > bb.buf.length) {
            bb.size = bb.buf.length;
            int togo = lesize - bb.buf.length;
            byte[] buf = new byte[togo];
            bb = new ByteBuffer(bb.ofs + bb.buf.length, togo, buf);
            this.buffers.add(bb);
        }
        this.len = (int)size;
    }

    public void flush() {
    }

    static class ByteBuffer {
        int ofs;
        int size;
        byte[] buf;

        ByteBuffer(int off, int len, byte[] buf) {
            this.ofs = off;
            this.size = len;
            this.buf = buf;
        }
    }
}

