/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.fresh.vfs.impl.mem.FileContent;

public class MemInputStream
extends InputStream {
    private int mark = -1;
    int pos = 0;
    private FileContent fc;

    public MemInputStream(FileContent fc) {
        this.fc = fc;
    }

    public int available() throws IOException {
        return (int)this.fc.getLength() - this.pos;
    }

    public void close() throws IOException {
        this.pos = 0;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rc = this.fc.read(this.pos, b, off, len);
        this.pos += rc;
        return rc;
    }

    public int read(byte[] b) throws IOException {
        int rc = this.fc.read(this.pos, b, 0, b.length);
        this.pos += rc;
        return rc;
    }

    public synchronized void reset() throws IOException {
        if (this.mark != -1) {
            this.pos = this.seek(this.mark);
        }
    }

    public long skip(long n) throws IOException {
        long skip = (long)this.pos + n;
        long cpos = this.seek((int)skip);
        return n - (skip - cpos);
    }

    public int read() throws IOException {
        return this.fc.read(this.pos++);
    }

    private int seek(int pos) {
        int len = (int)this.fc.getLength();
        if (pos > len) {
            return len;
        }
        return pos;
    }
}

