/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.fresh.vfs.impl.mem.FileContent;

public class MemOutputStream
extends OutputStream {
    private FileContent fc;
    int pos = 0;

    public MemOutputStream(FileContent fc) {
        this.fc = fc;
        fc.truncate(0L);
    }

    public void close() throws IOException {
        this.pos = 0;
    }

    public void flush() throws IOException {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fc.write(this.pos, b, off, len);
        this.pos += len;
    }

    public void write(byte[] b) throws IOException {
        this.fc.write(this.pos, b, 0, b.length);
        this.pos += b.length;
    }

    public void write(int b) throws IOException {
        this.fc.write(this.pos++, b);
    }

    private int seek(int pos) {
        int len = (int)this.fc.getLength();
        if (pos > len) {
            return len;
        }
        return pos;
    }
}

