/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.apache.log4j.Logger;
import org.jboss.fresh.registry.RegistryContext;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSMetaCacheUpdater;
import org.jboss.fresh.vfs.impl.mem.FNode;
import org.jboss.fresh.vfs.impl.mem.MemFile;

public class MemVFSMeta
implements VFSMeta {
    private static final String INTERNAL_FILE = "==__node__";
    private String sfJndiName;
    private VFSMetaCacheUpdater cup;
    RegistryContext fsroot;
    private static Logger log = Logger.getLogger(MemVFSMeta.class);

    public MemVFSMeta(String sfJndiName, String fsname) throws Exception {
        this.sfJndiName = sfJndiName;
        this.fsroot = new RegistryContext(fsname);
        FileInfo inf = new FileInfo(new FileName("/"));
        inf.setCreateDate(new Date());
        inf.setFileType(2);
        inf.setLastModified(inf.getCreateDate());
        inf.setLength(0L);
        Context rootCtx = (Context)this.fsroot.lookup("/");
        try {
            rootCtx.lookup(INTERNAL_FILE);
        }
        catch (NameNotFoundException ex) {
            rootCtx.bind(INTERNAL_FILE, (Object)this.fileInfoToFNode(inf));
        }
    }

    public void setCacheUpdater(VFSMetaCacheUpdater updater) {
        this.cup = updater;
    }

    public VFSMetaCacheUpdater getCacheUpdater() {
        return this.cup;
    }

    public Object getResolvedNode(String name) throws VFSException, NamingException {
        Object node = null;
        if ("/".equals(name)) {
            name = "";
        }
        for (int i = 0; i < 256; ++i) {
            FNode fnode;
            try {
                node = this.fsroot.lookup(name);
            }
            catch (NameNotFoundException ex) {
                // empty catch block
            }
            if (node instanceof FNode) {
                fnode = (FNode)node;
                if (fnode.getType() != 2) {
                    return node;
                }
            } else {
                return node;
            }
            name = fnode.getLinkRef();
        }
        throw new VFSException("Link resolution infinitely looped: " + name);
    }

    private FNode fileInfoToFNode(FileInfo finfo) {
        FNode node = new FNode();
        node.setName(finfo.getFileName().toString());
        node.setAttrs(finfo.getAttributes());
        node.setCreateDate(finfo.getCreateDate());
        node.setLastModified(finfo.getLastModified());
        node.setType(finfo.getFileType() == 1 ? 0 : (finfo.getFileType() == 2 ? 1 : 2));
        node.setMime(finfo.getMime());
        node.setFileContent(new MemFile());
        node.setLength(finfo.getLength());
        node.setTag(finfo.getTag());
        return node;
    }

    private FileInfo fnodeToFileInfo(FileName name, FNode node) throws VFSException {
        FileInfo inf = new FileInfo(name);
        inf.setAttributes(node.getAttrs());
        inf.setCreateDate(node.getCreateDate());
        inf.setFileType(node.getType() == 0 ? 1 : (node.getType() == 1 ? 2 : 3));
        inf.setLastModified(node.getLastModified());
        inf.setLength(node.getLength());
        inf.setMime(node.getMime());
        inf.setTag(node.getTag());
        if (node.getLink() != null) {
            inf.setTarget(new FileName(node.getLink()));
        }
        return inf;
    }

    private void updateFNodeWithFileInfo(FNode node, FileInfo finfo) {
        node.setAttrs(finfo.getAttributes());
        node.setCreateDate(finfo.getCreateDate());
        node.setLastModified(finfo.getLastModified());
        node.setType(finfo.getFileType() == 1 ? 0 : (finfo.getFileType() == 2 ? 1 : 2));
        node.setMime(finfo.getMime());
        node.setLength(finfo.getLength());
        node.setTag(finfo.getTag());
    }

    private FileInfo childToFileInfo(FileName name, Object child) throws VFSException, NamingException {
        if (child instanceof FNode) {
            return this.fnodeToFileInfo(name, (FNode)child);
        }
        if (child instanceof Context) {
            Context ctx = (Context)child;
            try {
                FNode node = (FNode)ctx.lookup(INTERNAL_FILE);
                return this.fnodeToFileInfo(name, node);
            }
            catch (NameNotFoundException ex) {
                throw new RuntimeException("Internal error - missing child node: ==__node__  (for key: " + name + ")");
            }
        }
        throw new RuntimeException("Internal error: child of illegal type: " + child.getClass().getName());
    }

    public boolean exists(FileName name) throws Exception {
        Object node = null;
        try {
            node = this.getResolvedNode(name.toString());
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return node != null;
    }

    public int countNamingEnum(NamingEnumeration enom) throws NamingException {
        int i = 0;
        while (enom.hasMore()) {
            enom.next();
            ++i;
        }
        return i;
    }

    public int countChildren(FileName path) throws Exception {
        NamingEnumeration<NameClassPair> names = null;
        Object node = null;
        try {
            node = this.getResolvedNode(path.toString());
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        if (node == null) {
            throw new VFSException("File not found: " + path);
        }
        if (!(node instanceof Context)) {
            throw new VFSException("File is not a directory");
        }
        try {
            names = ((Context)node).list("");
        }
        catch (NotContextException ex) {
            throw new VFSException("File is not a directory");
        }
        return this.countNamingEnum(names);
    }

    public List resolvePath(FileName path) throws Exception {
        LinkedList<FileName> ls = new LinkedList<FileName>();
        if (path == null) {
            ls.add(new FileName("/"));
            return ls;
        }
        Object node = null;
        String name = path.toString();
        for (int i = 0; i < 256; ++i) {
            FNode fnode;
            try {
                node = this.fsroot.lookup(name);
            }
            catch (NameNotFoundException ex) {
                node = null;
            }
            if (node instanceof FNode) {
                ls.add(new FileName(name));
                fnode = (FNode)node;
                if (fnode.getType() != 2) {
                    return ls;
                }
            } else {
                ls.add(new FileName(name));
                return ls;
            }
            name = fnode.getLinkRef();
        }
        throw new VFSException("Link resolution infinitely looped: " + name);
    }

    public FileInfo getFileInfo(FileName name) throws Exception {
        Object node = this.getResolvedNode(name.toString());
        if (node == null) {
            return null;
        }
        if (node instanceof FNode) {
            return this.fnodeToFileInfo(name, (FNode)node);
        }
        if (node instanceof Context) {
            Context ctx = (Context)node;
            try {
                node = ctx.lookup(INTERNAL_FILE);
            }
            catch (NameNotFoundException ex) {
                throw new RuntimeException("Internal error - missing child node: ==__node__  (for key: " + name + ")");
            }
        }
        if (node == null) {
            throw new RuntimeException("Internal error: node should not be null for key: " + name);
        }
        return this.fnodeToFileInfo(name, (FNode)node);
    }

    public List list(FileName path) throws Exception {
        NamingEnumeration<Binding> names = null;
        Object node = null;
        try {
            node = this.getResolvedNode(path.toString());
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        if (node == null) {
            throw new VFSException("File not found: " + path);
        }
        if (!(node instanceof Context)) {
            throw new VFSException("File is not a directory");
        }
        try {
            names = ((Context)node).listBindings("");
        }
        catch (NotContextException ex) {
            throw new VFSException("File is not a directory");
        }
        LinkedList<FileInfo> ls = new LinkedList<FileInfo>();
        while (names.hasMore()) {
            Binding binding = names.next();
            if (INTERNAL_FILE.equals(binding.getName())) continue;
            ls.add(this.childToFileInfo(path.absolutize(binding.getName().toString()), binding.getObject()));
        }
        return ls;
    }

    public Collection getLinks(FileName target) throws Exception {
        throw new RuntimeException();
    }

    public void create(FileInfo fi) throws Exception {
        try {
            if (fi.getFileType() == 2) {
                try {
                    this.fsroot.lookup(fi.getFileName().toString());
                    throw new VFSException("Directory exists already: " + fi.getFileName());
                }
                catch (NameNotFoundException ex) {
                    Context nuctx = this.fsroot.createSubcontext(fi.getFileName().toString());
                    nuctx.bind(INTERNAL_FILE, (Object)this.fileInfoToFNode(fi));
                }
            } else {
                this.fsroot.bind(fi.getFileName().toString(), (Object)this.fileInfoToFNode(fi));
            }
        }
        catch (NamingException ex) {
            throw new VFSException("Could not create file: " + fi.getFileName(), ex);
        }
    }

    public void update(FileInfo fi) throws Exception {
        Object node = null;
        try {
            node = this.fsroot.lookup(fi.getFileName().toString());
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (node == null) {
            throw new VFSException("File does not exist: " + fi.getFileName());
        }
        if (node instanceof FNode) {
            this.updateFNodeWithFileInfo((FNode)node, fi);
        } else if (node instanceof Context) {
            node = ((Context)node).lookup(INTERNAL_FILE);
            this.updateFNodeWithFileInfo((FNode)node, fi);
        } else {
            throw new RuntimeException("Internal error - Node is of wrong type: " + node.getClass().getName());
        }
    }

    public void remove(FileName name) throws Exception {
        Object node = null;
        try {
            node = this.fsroot.lookup(name.toString());
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        if (node == null) {
            throw new VFSException("File does not exist: " + name);
        }
        if (node instanceof FNode) {
            this.fsroot.unbind(name.toString());
        } else if (node instanceof Context) {
            String nnode = name.toString() + INTERNAL_FILE;
            Object co = this.fsroot.lookup(nnode);
            this.fsroot.unbind(nnode);
            try {
                this.fsroot.destroySubcontext(name.toString());
            }
            catch (Exception ex) {
                this.fsroot.bind(nnode, co);
                throw ex;
            }
            catch (Throwable t) {
                this.fsroot.bind(nnode, co);
                throw new RuntimeException("Error while removing directory: ", t);
            }
        } else {
            throw new RuntimeException("Internal error - Node is of wrong type: " + node.getClass().getName());
        }
    }

    public void rename(FileName oldPath, FileName newPath) throws Exception {
        Object node = null;
        try {
            node = this.fsroot.lookup(oldPath.toString());
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        if (node == null) {
            throw new RuntimeException("Internal error - Node does not exist: " + oldPath.toString());
        }
        if (node instanceof FNode) {
            this.fsroot.rename(oldPath.toString(), newPath.toString());
        } else if (node instanceof Context) {
            this.fsroot.rename(oldPath.toString(), newPath.toString());
            if (!newPath.getName().equals(oldPath.getName())) {
                try {
                    node = this.fsroot.lookup(newPath.toString() + INTERNAL_FILE);
                }
                catch (NameNotFoundException ex) {
                    // empty catch block
                }
                if (node == null) {
                    throw new RuntimeException("Internal error - Node does not exist: " + newPath.toString() + INTERNAL_FILE);
                }
                ((FNode)node).setName(newPath.getName());
            }
        } else {
            throw new RuntimeException("Internal error - Node is of wrong type: " + node.getClass().getName());
        }
    }

    public float moveBefore(FileName currFile, FileName nextFile) throws Exception {
        throw new RuntimeException("Method not implemented");
    }
}

