/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.util.Date;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.fresh.registry.RegistryContext;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.jboss.fresh.vfs.VFSStoreCacheUpdater;
import org.jboss.fresh.vfs.impl.mem.FNode;
import org.jboss.fresh.vfs.impl.mem.RAF;

public class MemVFSStore
implements VFSStore {
    private VFSMeta meta;
    private VFSStoreCacheUpdater cup;
    RegistryContext fsroot;
    private static Logger log = Logger.getLogger((String)"org.jboss.fresh.vfs.impl.mem.MemVFSStore");

    public MemVFSStore(VFSMeta meta, String fsname) throws Exception {
        this.meta = meta;
        this.fsroot = new RegistryContext(fsname);
    }

    public void setCacheUpdater(VFSStoreCacheUpdater updater) {
        this.cup = updater;
    }

    public VFSStoreCacheUpdater getCacheUpdater() {
        return this.cup;
    }

    public Object getResolvedNode(String name) throws VFSException, NamingException {
        Object node = null;
        for (int i = 0; i < 256; ++i) {
            FNode fnode;
            node = this.fsroot.lookup(name);
            if (node instanceof FNode) {
                fnode = (FNode)node;
                if (fnode.getType() != 2) {
                    return node;
                }
            } else {
                return node;
            }
            name = fnode.getLinkRef();
        }
        throw new VFSException("Link resolution infinitely looped: " + name);
    }

    public boolean hasContent(FileName filename) throws Exception {
        Object node = null;
        try {
            node = this.getResolvedNode(filename.toString());
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (node == null) {
            return false;
        }
        if (node instanceof FNode) {
            return ((FNode)node).getLength() > 0L;
        }
        if (node instanceof Context) {
            return false;
        }
        throw new RuntimeException("Internal error: child of illegal type: " + node.getClass().getName());
    }

    public void writeContent(FileOpInfo info) throws Exception {
        try {
            Object node = null;
            try {
                node = this.getResolvedNode(info.filename.toString());
            }
            catch (NameNotFoundException ex) {
                // empty catch block
            }
            if (node == null) {
                FileInfo finf = new FileInfo(info.filename);
                finf.setCreateDate(new Date());
                finf.setLastModified(new Date());
                finf.setFileType(1);
                finf.setLength(0L);
                finf.setMime("application/octet-stream");
                this.meta.create(finf);
                node = this.getResolvedNode(info.filename.toString());
            }
            RAF raf = null;
            if (node instanceof FNode) {
                raf = ((FNode)node).getFileContent().getRAF();
            } else if (node instanceof Context) {
                throw new VFSException(info.filename.toString() + " is a directory.");
            }
            if (info.append) {
                raf.seek(raf.getLength());
            } else {
                raf.seek(info.offset);
            }
            raf.write(info.buf, 0, info.buf.length);
            raf.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not write content", (Throwable)e);
            throw e;
        }
    }

    public FileReadInfo readContent(FileOpInfo info) throws Exception {
        FileReadInfo result = new FileReadInfo();
        Object node = null;
        try {
            node = this.getResolvedNode(info.filename.toString());
        }
        catch (NameNotFoundException ex) {
            // empty catch block
        }
        if (node == null) {
            throw new VFSException("File not found: " + info.filename);
        }
        RAF raf = null;
        if (node instanceof FNode) {
            raf = ((FNode)node).getFileContent().getRAF();
        } else if (node instanceof Context) {
            throw new VFSException(info.filename.toString() + " is a directory.");
        }
        raf.seek(info.offset);
        int size = 8192;
        int togo = (int)(raf.getLength() - info.offset);
        if (togo <= 0) {
            result.buf = new byte[0];
            result.more = false;
        } else if (togo > 0 && togo <= size) {
            result.buf = new byte[togo];
            result.more = false;
        } else {
            result.buf = new byte[size];
            result.more = true;
        }
        raf.read(result.buf);
        return result;
    }

    public void removeContent(FileName name) throws Exception {
    }

    public void rename(FileName oldPath, FileName newPath) throws Exception {
    }
}

