/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;
import org.jboss.fresh.vfs.impl.mem.FileContent;

public class RAF {
    FileContent fc;
    String enc;
    int pos = 0;

    public RAF(FileContent fc) {
        this.fc = fc;
    }

    public long getLength() {
        return this.fc.getLength();
    }

    public void write(byte[] val) {
        this.fc.write(this.pos, val, 0, val.length);
        this.pos += val.length;
    }

    public void write(byte[] val, int offs, int len) {
        this.fc.write(this.pos, val, offs, len);
        this.pos += len;
    }

    public void write(char[] val) throws IOException {
        this.write(val, 0, val.length);
    }

    public void write(char[] val, int offs, int len) throws IOException {
        if (this.enc != null) {
            this.write(new String(val, offs, len).getBytes(this.enc));
        } else {
            this.write(new String(val, offs, len).getBytes(this.enc));
        }
    }

    public int read(byte[] val) {
        int rc = this.fc.read(this.pos, val, 0, val.length);
        this.pos += rc;
        return rc;
    }

    public int read(byte[] val, int offs, int len) {
        int rc = this.fc.read(this.pos, val, offs, len);
        this.pos += rc;
        return rc;
    }

    public int read(char[] val) throws IOException {
        return this.read(val, 0, val.length);
    }

    public int read(char[] val, int offs, int len) throws IOException {
        byte[] buf = new byte[len];
        int rc = this.fc.read(this.pos, buf, 0, len);
        this.pos += rc;
        if (this.enc != null) {
            System.arraycopy(new String(buf, 0, rc, this.enc), 0, val, offs, rc);
        } else {
            System.arraycopy(new String(buf, 0, rc), 0, val, offs, rc);
        }
        return rc;
    }

    public long seek(long offset) {
        long ln = this.getLength();
        this.pos = offset > ln ? (int)ln : (int)offset;
        return this.pos;
    }

    public void close() {
        this.pos = 0;
    }

    public void truncate(long size) {
        this.fc.truncate(size);
    }
}

