/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.core.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonFeaturePackLayout;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;

public interface ProvisioningContext
extends AutoCloseable {
    public String getCoreVersion();

    public GalleonProvisioningConfig getConfig(GalleonProvisioningConfig var1) throws ProvisioningException;

    public void storeProvisioningConfig(GalleonProvisioningConfig var1, Path var2) throws XMLStreamException, IOException, ProvisioningException;

    public GalleonProvisioningRuntime getProvisioningRuntime(GalleonProvisioningConfig var1) throws ProvisioningException;

    public UniverseResolver getUniverseResolver();

    default public void provision(GalleonProvisioningConfig config) throws ProvisioningException {
        this.provision(config, Collections.emptyList(), Collections.emptyMap());
    }

    public void provision(GalleonProvisioningConfig var1, List<Path> var2, Map<String, String> var3) throws ProvisioningException;

    public void provision(Path var1, Map<String, String> var2) throws ProvisioningException;

    public GalleonProvisioningConfig parseProvisioningFile(Path var1) throws ProvisioningException;

    public List<GalleonFeaturePackLayout> getOrderedFeaturePackLayouts(GalleonProvisioningConfig var1) throws ProvisioningException;

    public Set<String> getOrderedFeaturePackPluginLocations(GalleonProvisioningConfig var1) throws ProvisioningException;

    public GalleonConfigurationWithLayersBuilderItf buildConfigurationBuilder(GalleonConfigurationWithLayers var1);

    public List<String> getInstalledPacks(Path var1) throws ProvisioningException;

    public GalleonProvisioningConfig loadProvisioningConfig(InputStream var1) throws ProvisioningException, XMLStreamException;

    public FsDiff getFsDiff() throws ProvisioningException;

    public void install(FeaturePackLocation var1) throws ProvisioningException;

    public void install(GalleonFeaturePackConfig var1) throws ProvisioningException;

    public void uninstall(FeaturePackLocation.FPID var1) throws ProvisioningException;

    public boolean hasOrderedFeaturePacksConfig(GalleonProvisioningConfig var1, ConfigId var2) throws ProvisioningException;

    public GalleonProvisioningLayout newProvisioningLayout(GalleonProvisioningConfig var1) throws ProvisioningException;

    public GalleonProvisioningLayout newProvisioningLayout(Path var1, boolean var2) throws ProvisioningException;

    @Override
    public void close();
}

