/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProvisioningLightXmlParser {
    private static final String FEATURE_PACK = "feature-pack";
    private static final String UNIVERSES = "universes";
    private static final String UNIVERSE = "universe";
    private static final String DEFAULT_UNIVERSE = "";

    ProvisioningLightXmlParser() {
    }

    public static List<FeaturePackLocation.FPID> parse(Path configFile) throws ProvisioningException {
        List<FeaturePackLocation.FPID> list;
        FileInputStream fileInputStream = new FileInputStream(configFile.toFile());
        try {
            list = ProvisioningLightXmlParser.parse(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ProvisioningException(ex);
            }
        }
        fileInputStream.close();
        return list;
    }

    public static List<FeaturePackLocation.FPID> parse(InputStream fileInputStream) throws ProvisioningException {
        ArrayList<FeaturePackLocation.FPID> featurePacks = new ArrayList<FeaturePackLocation.FPID>();
        try {
            Element e;
            Node n;
            int i;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileInputStream);
            Element root = document.getDocumentElement();
            NodeList lst = root.getChildNodes();
            HashMap<String, UniverseSpec> universes = new HashMap<String, UniverseSpec>();
            for (i = 0; i < lst.getLength(); ++i) {
                n = lst.item(i);
                if (!(n instanceof Element) || !UNIVERSES.equals(n.getNodeName())) continue;
                e = (Element)n;
                NodeList lstUniverses = e.getChildNodes();
                for (int j = 0; j < lstUniverses.getLength(); ++j) {
                    Node u = lstUniverses.item(j);
                    if (!(u instanceof Element) || !UNIVERSE.equals(u.getNodeName())) continue;
                    Element uElement = (Element)u;
                    String name = uElement.getAttribute("name");
                    if (name == null) {
                        name = DEFAULT_UNIVERSE;
                    }
                    String factory = uElement.getAttribute("factory");
                    String loc = uElement.getAttribute("location");
                    UniverseSpec spec = new UniverseSpec(factory, loc);
                    universes.put(name, spec);
                }
            }
            for (i = 0; i < lst.getLength(); ++i) {
                n = lst.item(i);
                if (!(n instanceof Element) || !FEATURE_PACK.equals(n.getNodeName())) continue;
                e = (Element)n;
                String loc = e.getAttribute("location");
                FeaturePackLocation location = FeaturePackLocation.fromString(loc);
                UniverseSpec spec = null;
                if (location.getUniverse() == null) {
                    spec = (UniverseSpec)universes.get(DEFAULT_UNIVERSE);
                } else if (location.getUniverse().getLocation() == null) {
                    spec = (UniverseSpec)universes.get(location.getUniverse().getFactory());
                }
                if (spec != null) {
                    FeaturePackLocation l;
                    location = l = new FeaturePackLocation(spec, location.getProducerName(), location.getChannelName(), location.getFrequency(), location.getBuild());
                }
                featurePacks.add(location.getFPID());
            }
        }
        catch (Exception ex) {
            throw new ProvisioningException(ex);
        }
        return featurePacks;
    }
}

