/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;

public class MavenErrors {
    public static void missingGroupId() throws MavenUniverseException {
        throw new MavenUniverseException("Artifact is missing groupId");
    }

    public static void missingArtifactId() throws MavenUniverseException {
        throw new MavenUniverseException("Artifact is missing artifactId");
    }

    public static void missingVersion(MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Artifact " + artifact.getGroupId() + ':' + artifact.getArtifactId() + " is missing version");
    }

    public static void missingVersionRange(MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Artifact " + artifact.getGroupId() + ':' + artifact.getArtifactId() + " is missing version range");
    }

    public static void missingExtension(MavenArtifact artifact) throws MavenUniverseException {
        throw new MavenUniverseException("Artifact " + artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + " is missing extension");
    }

    public static MavenUniverseException producerNotFound(String producerName) {
        return new MavenUniverseException("Producer " + producerName + " is not found in the universe");
    }

    public static MavenUniverseException channelNotFound(String producer, String channelName) {
        return new MavenUniverseException("Channel " + channelName + " is not found in producer " + producer);
    }

    public static MavenUniverseException artifactNotFound(MavenArtifact artifact, Path repoHome) {
        return new MavenUniverseException("Artifact " + artifact.getCoordsAsString() + " not found in " + repoHome);
    }

    public static String failedToResolveLatestVersion(String str) {
        return "Failed to determine the latest version of " + str;
    }
}

