/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenChannelDescription;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenProducerBase;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.xml.MavenChannelSpecXmlWriter;
import org.jboss.galleon.universe.maven.xml.MavenProducerXmlWriter;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenProducerInstaller
extends MavenProducerBase {
    private Set<String> frequencies = Collections.emptySet();
    private String defaultFrequency;
    private Map<String, MavenChannel> channels = new HashMap<String, MavenChannel>();
    private boolean installed;

    public MavenProducerInstaller(String name, MavenRepoManager repoManager, MavenArtifact artifact) throws MavenUniverseException {
        this(name, repoManager, artifact, null, null);
    }

    public MavenProducerInstaller(String name, MavenRepoManager repoManager, MavenArtifact artifact, String fpGroupId, String fpArtifactId) throws MavenUniverseException {
        super(name, repoManager, artifact);
        this.fpGroupId = fpGroupId;
        this.fpArtifactId = fpArtifactId;
    }

    public MavenProducerInstaller(String name, MavenRepoManager repoManager, MavenArtifact artifact, MavenArtifact extendArtifact) throws MavenUniverseException {
        super(name, repoManager, artifact);
        this.extendProducer(name, extendArtifact);
    }

    public MavenProducerInstaller extendProducer(String name, MavenArtifact extendArtifact) throws MavenUniverseException {
        MavenProducer otherProducer = new MavenProducer(name, this.repo, extendArtifact);
        if (this.fpGroupId == null) {
            this.fpGroupId = otherProducer.getFeaturePackGroupId();
        }
        if (this.fpArtifactId == null) {
            this.fpArtifactId = otherProducer.getFeaturePackArtifactId();
        }
        if (this.frequencies.isEmpty()) {
            this.frequencies = new HashSet<String>(otherProducer.getFrequencies());
        } else {
            this.frequencies.addAll(otherProducer.getFrequencies());
        }
        if (this.defaultFrequency == null) {
            this.defaultFrequency = otherProducer.getDefaultFrequency();
        }
        for (MavenChannel channel : otherProducer.getChannels()) {
            this.addChannel(channel);
        }
        return this;
    }

    public MavenProducerInstaller addFrequency(String name) throws MavenUniverseException {
        return this.addFrequency(name, false);
    }

    public MavenProducerInstaller addFrequency(String name, boolean isDefault) throws MavenUniverseException {
        if (this.frequencies.isEmpty()) {
            this.frequencies = new HashSet<String>();
        }
        this.frequencies.add(name);
        if (isDefault) {
            this.defaultFrequency = name;
        }
        return this;
    }

    public MavenProducerInstaller addFrequencies(String ... names) {
        if (this.frequencies.isEmpty()) {
            this.frequencies = new HashSet<String>(names.length);
        }
        for (String frequency : names) {
            this.frequencies.add(frequency);
        }
        return this;
    }

    public boolean hasFrequencies() {
        return !this.frequencies.isEmpty();
    }

    @Override
    public Collection<String> getFrequencies() {
        return this.frequencies;
    }

    public boolean hasDefaultFrequency() {
        return this.defaultFrequency != null;
    }

    @Override
    public String getDefaultFrequency() {
        return this.defaultFrequency;
    }

    public MavenProducerInstaller removeFrequency(String frequency) {
        this.frequencies.remove(frequency);
        return this;
    }

    public MavenProducerInstaller addChannel(String channelName, String versionRange) throws MavenUniverseException {
        return this.addChannel(new MavenChannel(this, channelName, versionRange));
    }

    public MavenProducerInstaller addChannel(MavenChannel channel) throws MavenUniverseException {
        this.channels.put(channel.getName(), channel);
        return this;
    }

    public MavenProducerInstaller removeChannel(String channelName) {
        if (!this.channels.isEmpty()) {
            this.channels.remove(channelName);
        }
        return this;
    }

    public boolean hasChannel(String name) throws MavenUniverseException {
        return this.channels.containsKey(name);
    }

    public MavenChannel getChannel(String channelName) throws MavenUniverseException {
        MavenChannel channel = this.channels.get(channelName);
        if (channel == null) {
            throw MavenErrors.channelNotFound(this.name, channelName);
        }
        return channel;
    }

    @Override
    public Collection<MavenChannel> getChannels() throws MavenUniverseException {
        return this.channels.values();
    }

    public MavenProducerInstaller install() throws MavenUniverseException {
        if (this.installed) {
            throw new MavenUniverseException("The universe has already been installed");
        }
        if (this.defaultFrequency == null) {
            this.defaultFrequency = "final";
            if (!this.frequencies.contains(this.defaultFrequency)) {
                this.frequencies = CollectionUtils.add(this.frequencies, (Object)this.defaultFrequency);
            }
        }
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("gln-mvn-producer", new FileAttribute[0]);
            Path zipRoot = tmpDir.resolve("root");
            MavenProducerInstaller.addProducerDescription(this, zipRoot);
            Path artifactFile = tmpDir.resolve(this.artifact.getArtifactFileName());
            Files.createDirectories(artifactFile.getParent(), new FileAttribute[0]);
            ZipUtils.zip((Path)zipRoot, (Path)artifactFile);
            this.repo.install(this.artifact, artifactFile);
            this.installed = true;
            MavenProducerInstaller mavenProducerInstaller = this;
            return mavenProducerInstaller;
        }
        catch (IOException | XMLStreamException e) {
            throw new MavenUniverseException("Failed to create Maven universe producer artifact", e);
        }
        finally {
            if (tmpDir != null) {
                IoUtils.recursiveDelete((Path)tmpDir);
            }
        }
    }

    static void addProducerDescription(MavenProducerDescription<?> producer, Path zipRoot) throws XMLStreamException, IOException, MavenUniverseException {
        Path producerDir = MavenProducerInstaller.getProducerDir(zipRoot, producer.getName());
        MavenProducerXmlWriter.getInstance().write(producer, producerDir.resolve("maven-producer.xml"));
        Path channelsDir = producerDir.resolve("channels");
        Files.createDirectory(channelsDir, new FileAttribute[0]);
        for (MavenChannelDescription channel : producer.getChannels()) {
            Path channelDir = channelsDir.resolve(channel.getName());
            Files.createDirectory(channelDir, new FileAttribute[0]);
            Path channelXml = channelDir.resolve("maven-channel.xml");
            MavenChannelSpecXmlWriter.getInstance().write(channel, channelXml);
        }
    }
}

