/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.xml;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.xml.MavenProducerXmlParser10;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.Node;
import org.jboss.galleon.xml.util.TextNode;

public class MavenProducerXmlWriter
extends BaseXmlWriter<MavenProducerDescription<?>> {
    private static final MavenProducerXmlWriter INSTANCE = new MavenProducerXmlWriter();

    public static MavenProducerXmlWriter getInstance() {
        return INSTANCE;
    }

    protected ElementNode toElement(MavenProducerDescription<?> producer) throws XMLStreamException {
        ElementNode producerEl = MavenProducerXmlWriter.addElement(null, (XmlNameProvider)MavenProducerXmlParser10.Element.PRODUCER);
        MavenProducerXmlWriter.addAttribute((ElementNode)producerEl, (XmlNameProvider)MavenProducerXmlParser10.Attribute.NAME, (String)producer.getName());
        if (producer.getFeaturePackGroupId() != null) {
            MavenProducerXmlWriter.addElement((ElementNode)producerEl, (XmlNameProvider)MavenProducerXmlParser10.Element.FP_GROUP_ID).addChild((Node)new TextNode(producer.getFeaturePackGroupId()));
        }
        if (producer.getFeaturePackArtifactId() != null) {
            MavenProducerXmlWriter.addElement((ElementNode)producerEl, (XmlNameProvider)MavenProducerXmlParser10.Element.FP_ARTIFACT_ID).addChild((Node)new TextNode(producer.getFeaturePackArtifactId()));
        }
        ElementNode frequenciesEl = MavenProducerXmlWriter.addElement((ElementNode)producerEl, (XmlNameProvider)MavenProducerXmlParser10.Element.FREQUENCIES);
        Collection<String> frequencies = producer.getFrequencies();
        String defaultFrequency = producer.getDefaultFrequency();
        for (String frequency : frequencies) {
            ElementNode frequencyE = MavenProducerXmlWriter.addElement((ElementNode)frequenciesEl, (XmlNameProvider)MavenProducerXmlParser10.Element.FREQUENCY);
            if (defaultFrequency != null && frequency.equals(defaultFrequency)) {
                MavenProducerXmlWriter.addAttribute((ElementNode)frequencyE, (XmlNameProvider)MavenProducerXmlParser10.Attribute.DEFAULT, (String)"true");
            }
            frequencyE.addChild((Node)new TextNode(frequency));
        }
        return producerEl;
    }
}

