/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducerDescription;
import org.jboss.galleon.universe.maven.MavenProducerInstaller;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenProducers {
    private final MavenRepoManager repoManager;
    private final MavenArtifact artifact;
    private final List<MavenProducerDescription<?>> producers = new ArrayList();

    public static MavenProducers getInstance(MavenRepoManager repoManager, MavenArtifact artifact) {
        return new MavenProducers(repoManager, artifact);
    }

    private MavenProducers(MavenRepoManager repoManager, MavenArtifact artifact) {
        this.repoManager = repoManager;
        this.artifact = artifact;
    }

    public void addProducer(MavenProducerDescription<?> producer) {
        this.producers.add(producer);
    }

    public void install() throws MavenUniverseException {
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("gln-mvn-channel", new FileAttribute[0]);
            Path zipRoot = tmpDir.resolve("root");
            for (MavenProducerDescription<?> producer : this.producers) {
                MavenProducerInstaller.addProducerDescription(producer, zipRoot);
            }
            Path artifactFile = tmpDir.resolve(this.artifact.getArtifactFileName());
            Files.createDirectories(artifactFile.getParent(), new FileAttribute[0]);
            ZipUtils.zip((Path)zipRoot, (Path)artifactFile);
            this.repoManager.install(this.artifact, artifactFile);
        }
        catch (IOException | XMLStreamException e) {
            throw new MavenUniverseException("Failed to create Maven universe producer artifact", e);
        }
        finally {
            if (tmpDir != null) {
                IoUtils.recursiveDelete((Path)tmpDir);
            }
        }
    }
}

