/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class MvnNoLocUniverse
implements Universe<MvnNoLocUniverse>,
Producer<MvnNoLocUniverse>,
Channel {
    public static final String NAME = "no-loc";
    protected final MavenRepoManager repo;

    public MvnNoLocUniverse(MavenRepoManager repo) {
        this.repo = repo;
    }

    public String getFactoryId() {
        return "maven";
    }

    public String getLocation() {
        return null;
    }

    public boolean hasProducer(String producerName) throws ProvisioningException {
        return true;
    }

    public MvnNoLocUniverse getProducer(String producerName) throws ProvisioningException {
        return this;
    }

    public Collection<MvnNoLocUniverse> getProducers() throws ProvisioningException {
        return Collections.emptyList();
    }

    public String getName() {
        return NAME;
    }

    public boolean hasFrequencies() {
        return false;
    }

    public Collection<String> getFrequencies() {
        return Collections.emptyList();
    }

    public boolean hasDefaultFrequency() {
        return false;
    }

    public String getDefaultFrequency() {
        return null;
    }

    public boolean hasChannel(String name) throws ProvisioningException {
        return NAME.equals(name);
    }

    public MvnNoLocUniverse getChannel(String name) throws ProvisioningException {
        return name == null || NAME.equals(name) ? this : null;
    }

    public Collection<MvnNoLocUniverse> getChannels() throws ProvisioningException {
        return Collections.emptyList();
    }

    public boolean hasDefaultChannel() {
        return false;
    }

    public MvnNoLocUniverse getDefaultChannel() {
        return null;
    }

    public String getLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        return this.getLatestBuild(fpl.getFPID());
    }

    public List<String> getAllBuilds(FeaturePackLocation fpl) throws ProvisioningException {
        return this.repo.getAllVersions(MvnNoLocUniverse.toArtifact(fpl.getFPID()));
    }

    public String getLatestBuild(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        return this.repo.getLatestVersion(MvnNoLocUniverse.toArtifact(fpid));
    }

    public Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = MvnNoLocUniverse.toArtifact(fpl.getFPID());
        this.repo.resolve(artifact);
        return artifact.getPath();
    }

    public boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        this.repo.isResolved(MvnNoLocUniverse.toArtifact(fpl.getFPID()));
        return false;
    }

    public boolean isDevBuild(FeaturePackLocation.FPID fpid) {
        return new MavenArtifactVersion(fpid.getBuild()).isSnapshot();
    }

    public void install(FeaturePackLocation.FPID fpid, Path fpZip) throws ProvisioningException {
        this.repo.install(MvnNoLocUniverse.toArtifact(fpid), fpZip);
    }

    private static MavenArtifact toArtifact(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        String coords = fpid.getProducer().getName();
        MavenArtifact artifact = new MavenArtifact();
        int colon = MvnNoLocUniverse.nextColon(coords, 0);
        artifact.setGroupId(coords.substring(0, colon));
        int prevColon = colon;
        colon = MvnNoLocUniverse.nextColon(coords, colon);
        artifact.setArtifactId(coords.substring(prevColon + 1, colon));
        prevColon = colon;
        colon = MvnNoLocUniverse.nextColon(coords, colon);
        artifact.setClassifier(coords.substring(prevColon + 1, colon));
        artifact.setExtension(coords.substring(colon + 1));
        artifact.setVersion(fpid.getBuild());
        return artifact;
    }

    private static int nextColon(String coords, int colon) throws ProvisioningException {
        if ((colon = coords.indexOf(58, colon + 1)) < 0) {
            throw new ProvisioningException(MvnNoLocUniverse.invalidCoords(coords));
        }
        return colon;
    }

    private static String invalidCoords(String coords) {
        return coords + " does not follow format groupId:artifactId:[classifier]:extension:version";
    }
}

