/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenProducerBase;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseBase;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.xml.MavenProducerSpecXmlWriter;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenUniverseInstaller
extends MavenUniverseBase {
    private Map<String, MavenProducer> producers = new HashMap<String, MavenProducer>();
    private boolean installed;

    public MavenUniverseInstaller(MavenRepoManager repoManager, MavenArtifact artifact) {
        super(repoManager, artifact);
    }

    public MavenUniverseInstaller extendUniverse(MavenArtifact extendArtifact) throws MavenUniverseException {
        MavenUniverse otherUniverse = new MavenUniverse(this.repo, extendArtifact);
        for (MavenProducer producer : otherUniverse.getProducers()) {
            this.addProducer(producer);
        }
        return this;
    }

    public MavenUniverseInstaller addProducer(String producer, String groupId, String artifactId, String versionRange) throws MavenUniverseException {
        return this.addProducer(producer, new MavenArtifact().setGroupId(groupId).setArtifactId(artifactId).setVersionRange(versionRange));
    }

    public MavenUniverseInstaller addProducer(String producer, MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.getVersionRange() == null) {
            MavenErrors.missingVersionRange(artifact);
        }
        return this.addProducer(new MavenProducer(producer, this.repo, artifact));
    }

    public MavenUniverseInstaller addProducer(MavenProducer producer) throws MavenUniverseException {
        this.producers.put(producer.getName(), producer);
        return this;
    }

    public MavenUniverseInstaller removeProducer(String producerName) {
        if (!this.producers.isEmpty()) {
            this.producers.remove(producerName);
        }
        return this;
    }

    public void install() throws MavenUniverseException {
        if (this.installed) {
            throw new MavenUniverseException("The universe has already been installed");
        }
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("gln-mvn-universe", new FileAttribute[0]);
            Path zipRoot = tmpDir.resolve("root");
            Path locations = MavenUniverseInstaller.getProducerLocations(zipRoot);
            Files.createDirectories(locations, new FileAttribute[0]);
            for (MavenProducerBase mavenProducerBase : this.producers.values()) {
                Path producerDir = locations.resolve(mavenProducerBase.getName());
                Files.createDirectory(producerDir, new FileAttribute[0]);
                Path producerXml = producerDir.resolve("maven-producer.xml");
                MavenProducerSpecXmlWriter.getInstance().write(mavenProducerBase, producerXml);
            }
            Path artifactFile = tmpDir.resolve(this.artifact.getArtifactFileName());
            Files.createDirectories(artifactFile.getParent(), new FileAttribute[0]);
            ZipUtils.zip((Path)zipRoot, (Path)artifactFile);
            this.repo.install(this.artifact, artifactFile);
        }
        catch (IOException | XMLStreamException e) {
            throw new MavenUniverseException("Failed to create Maven universe artifact", e);
        }
        finally {
            if (tmpDir != null) {
                IoUtils.recursiveDelete((Path)tmpDir);
            }
        }
        this.installed = true;
    }

    public boolean hasProducer(String producerName) throws MavenUniverseException {
        return this.producers.containsKey(producerName);
    }

    public MavenProducer getProducer(String producerName) throws MavenUniverseException {
        MavenProducer producer = this.producers.get(producerName);
        if (producer == null) {
            throw MavenErrors.producerNotFound(producerName);
        }
        return producer;
    }

    public Collection<MavenProducer> getProducers() throws MavenUniverseException {
        return this.producers.values();
    }
}

