/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.maven.plugin.util.LoggerMessageWriter;
import org.jboss.galleon.xml.ProvisioningXmlParser;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class FeaturePackProvisioningMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project.build.sourceEncoding}", required=true, property="pm.encoding")
    private String encoding;
    @Inject
    private LoggerMessageWriter messageWriter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProvisioningConfig provisioningConfig;
        String provXmlArg = (String)this.repoSession.getSystemProperties().get("provisioning.xml");
        if (provXmlArg == null) {
            throw new MojoExecutionException(FpMavenErrors.propertyMissing("provisioning.xml"));
        }
        Path provXml = Paths.get(provXmlArg, new String[0]);
        if (!Files.exists(provXml, new LinkOption[0])) {
            throw new MojoExecutionException(Errors.pathDoesNotExist((Path)provXml));
        }
        String installDirArg = (String)this.repoSession.getSystemProperties().get("pm.target.dir");
        if (installDirArg == null) {
            throw new MojoExecutionException(FpMavenErrors.propertyMissing("pm.target.dir"));
        }
        Path installDir = Paths.get(installDirArg, new String[0]);
        try (BufferedReader r = Files.newBufferedReader(provXml, Charset.forName(this.encoding));){
            provisioningConfig = ProvisioningXmlParser.getInstance().parse((Reader)r);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(Errors.pathDoesNotExist((Path)provXml), (Exception)e);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(Errors.parseXml((Path)provXml), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.openFile((Path)provXml), (Exception)e);
        }
        try {
            ProvisioningManager.builder().setEncoding(this.encoding).setInstallationHome(installDir).setArtifactResolver(new ArtifactRepositoryManager(){

                public Path resolve(ArtifactCoords coords) throws ArtifactException {
                    ArtifactResult result;
                    try {
                        result = FeaturePackProvisioningMojo.this.repoSystem.resolveArtifact(FeaturePackProvisioningMojo.this.repoSession, FeaturePackProvisioningMojo.this.getArtifactRequest(coords));
                    }
                    catch (ArtifactResolutionException e) {
                        throw new ArtifactException(FpMavenErrors.artifactResolution(coords), (Throwable)e);
                    }
                    if (!result.isResolved()) {
                        throw new ArtifactException(FpMavenErrors.artifactResolution(coords));
                    }
                    if (result.isMissing()) {
                        throw new ArtifactException(FpMavenErrors.artifactMissing(coords));
                    }
                    return Paths.get(result.getArtifact().getFile().toURI());
                }

                public void install(ArtifactCoords coords, Path file) throws ArtifactException {
                    InstallRequest request = new InstallRequest();
                    DefaultArtifact artifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion());
                    artifact.setFile(file.toFile());
                    try {
                        FeaturePackProvisioningMojo.this.repoSystem.install(FeaturePackProvisioningMojo.this.repoSession, request);
                    }
                    catch (InstallationException ex) {
                        throw new ArtifactException(ex.getMessage(), (Throwable)ex);
                    }
                }

                public void deploy(ArtifactCoords coords, Path file) throws ArtifactException {
                    DeployRequest request = new DeployRequest();
                    DefaultArtifact artifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion());
                    artifact.setFile(file.toFile());
                    try {
                        FeaturePackProvisioningMojo.this.repoSystem.deploy(FeaturePackProvisioningMojo.this.repoSession, request);
                    }
                    catch (DeploymentException ex) {
                        throw new ArtifactException(ex.getMessage(), (Throwable)ex);
                    }
                }

                public String getHighestVersion(ArtifactCoords coords, String range) throws ArtifactException {
                    throw new UnsupportedOperationException("Not supported operation.");
                }
            }).setMessageWriter((MessageWriter)this.messageWriter).build().provision(provisioningConfig);
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to provision the installation", (Exception)((Object)e));
        }
    }

    private ArtifactRequest getArtifactRequest(ArtifactCoords coords) {
        ArtifactRequest req = new ArtifactRequest();
        req.setArtifact((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion()));
        req.setRepositories(this.remoteRepos);
        return req;
    }
}

