/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.maven.plugin.util.ConfigurationId;
import org.jboss.galleon.repomanager.FeaturePackRepositoryManager;
import org.jboss.galleon.xml.ConfigXmlParser;

public class FeaturePackInstaller {
    private final Path repoHome;
    private final Path installationDir;
    private final Path configuration;
    private final List<ConfigurationId> configs;
    private final String featurePackGav;
    private final boolean inheritPackages;
    private final boolean inheritConfigs;
    private final List<String> includedPackages;
    private final List<String> excludedPackages;
    private final Map<String, String> options;

    public FeaturePackInstaller(Path repoHome, Path installationDir, Path configuration, List<ConfigurationId> configs, String featurePackGav, boolean inheritConfigs, boolean inheritPackages, List<String> includedPackages, List<String> excludedPackages, Map<String, String> options) {
        this.repoHome = repoHome;
        this.installationDir = installationDir;
        this.configuration = configuration;
        this.inheritConfigs = inheritConfigs;
        this.inheritPackages = inheritPackages;
        this.featurePackGav = featurePackGav;
        this.configs = configs == null ? Collections.emptyList() : configs;
        this.includedPackages = includedPackages == null ? Collections.emptyList() : includedPackages;
        this.excludedPackages = excludedPackages == null ? Collections.emptyList() : excludedPackages;
        this.options = options == null ? Collections.emptyMap() : options;
    }

    public void install() {
        try {
            ProvisioningManager manager = this.getManager();
            System.setProperty("org.wildfly.logging.skipLogManagerCheck", "true");
            ConfigModel config = null;
            if (this.configuration != null && Files.exists(this.configuration, new LinkOption[0])) {
                try {
                    BufferedReader reader = Files.newBufferedReader(this.configuration);
                    Iterator<String> iterator = null;
                    try {
                        config = ConfigXmlParser.getInstance().parse((Reader)reader);
                    }
                    catch (Throwable throwable) {
                        iterator = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (iterator != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)iterator)).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException | XMLStreamException ex) {
                    throw new IllegalArgumentException("Couldn't load the customization configuration " + this.configuration, ex);
                }
            }
            FeaturePackConfig.Builder fpConfigBuilder = (FeaturePackConfig.Builder)FeaturePackConfig.builder((ArtifactCoords.Gav)ArtifactCoords.newGav((String)this.featurePackGav)).setInheritPackages(this.inheritPackages).setInheritConfigs(this.inheritConfigs);
            if (this.configs != null && !this.configs.isEmpty()) {
                for (ConfigurationId configId : this.configs) {
                    if (configId.isModelOnly()) {
                        fpConfigBuilder.includeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfigBuilder.includeDefaultConfig(configId.getId());
                }
            }
            if (config != null) {
                fpConfigBuilder.addConfig(config);
            }
            if (this.includedPackages != null && !this.includedPackages.isEmpty()) {
                for (String includedPackage : this.includedPackages) {
                    fpConfigBuilder.includePackage(includedPackage);
                }
            }
            if (this.excludedPackages != null && !this.excludedPackages.isEmpty()) {
                for (String excludedPackage : this.excludedPackages) {
                    fpConfigBuilder.excludePackage(excludedPackage);
                }
            }
            manager.install(fpConfigBuilder.build(), this.options);
        }
        catch (ProvisioningException ex) {
            throw new IllegalArgumentException("Couldn't install the feature pack " + this.featurePackGav, ex);
        }
        finally {
            System.clearProperty("org.wildfly.logging.skipLogManagerCheck");
        }
    }

    private ProvisioningManager getManager() {
        return ProvisioningManager.builder().setArtifactResolver((ArtifactRepositoryManager)FeaturePackRepositoryManager.newInstance((Path)this.repoHome)).setInstallationHome(this.installationDir).build();
    }
}

