/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryUserDatabase;
import org.jboss.gravia.container.tomcat.extension.RolePrincipal;
import org.jboss.gravia.container.tomcat.extension.UserPrincipal;

public class UserDatabaseLoginModule
implements LoginModule {
    private UserDatabase userDatabase;
    private CallbackHandler callbackHandler;
    private UserPrincipal userPrincipal;
    private RolePrincipal rolePrincipal;
    private Subject subject;
    private String login;
    private List<String> userGroups;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        try {
            this.userDatabase = new MemoryUserDatabase();
            this.userDatabase.open();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot open user database", ex);
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        this.userGroups = new ArrayList<String>();
        try {
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            User user = this.userDatabase.findUser(username);
            if (user != null && user.getPassword().equals(password)) {
                this.login = username;
                Iterator roles = user.getRoles();
                while (roles.hasNext()) {
                    Role role = (Role)roles.next();
                    this.userGroups.add(role.getName());
                }
                return true;
            }
            throw new LoginException("Authentication failed");
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.login == null || this.userGroups.isEmpty()) {
            return false;
        }
        this.userPrincipal = new UserPrincipal(this.login);
        this.subject.getPrincipals().add(this.userPrincipal);
        for (String groupName : this.userGroups) {
            this.rolePrincipal = new RolePrincipal(groupName);
            this.subject.getPrincipals().add(this.rolePrincipal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.login = null;
        this.userPrincipal = null;
        this.rolePrincipal = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.rolePrincipal);
        return true;
    }
}

