/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.spi;

import java.util.Comparator;
import org.osgi.framework.ServiceReference;

final class ServiceReferenceComparator
implements Comparator<ServiceReference<?>> {
    private static final Comparator<ServiceReference<?>> INSTANCE = new ServiceReferenceComparator();

    static Comparator<ServiceReference<?>> getInstance() {
        return INSTANCE;
    }

    private ServiceReferenceComparator() {
    }

    @Override
    public int compare(ServiceReference<?> ref1, ServiceReference<?> ref2) {
        long otherRanking;
        long otherId;
        long thisId = this.getProperty(ref1, "service.id");
        if (thisId == (otherId = this.getProperty(ref1, "service.id"))) {
            return 0;
        }
        long thisRanking = this.getProperty(ref1, "service.ranking");
        if (thisRanking != (otherRanking = this.getProperty(ref2, "service.ranking"))) {
            return thisRanking < otherRanking ? -1 : 1;
        }
        return thisId > otherId ? -1 : 1;
    }

    private long getProperty(ServiceReference<?> sref, String property) {
        Object value = sref.getProperty(property);
        return value != null ? new Long(value.toString()) : 0L;
    }
}

