/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.spi.AbstractRepository;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.NotNullException;

public class RepositoryAggregator
extends AbstractRepository {
    private final List<Repository> delegates;

    public RepositoryAggregator(PropertiesProvider propertiesProvider, Repository ... delegates) {
        super(propertiesProvider);
        NotNullException.assertValue((Object)delegates, (String)"delegates");
        this.delegates = Arrays.asList(delegates);
    }

    public List<Repository> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        for (Repository repo : this.delegates) {
            Collection<Capability> providers = repo.findProviders(req);
            if (providers.isEmpty()) continue;
            return providers;
        }
        return Collections.emptyList();
    }
}

