/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private IOUtils() {
    }

    public static long copyStream(InputStream input, OutputStream output) throws IOException {
        int len = 0;
        long total = 0L;
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) >= 0) {
            output.write(buf, 0, len);
            total += (long)len;
        }
        IOUtils.safeClose(input);
        IOUtils.safeClose(output);
        return total;
    }

    public static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

