/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.internal;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Set;
import javax.management.JMException;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ProvisionResult;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={Provisioner.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public final class ProvisionerService
implements Provisioner {
    private Resolver resolver;
    private Repository repository;
    private ResourceInstaller installer;
    private RuntimeEnvironment environment;
    private Provisioner delegate;

    @Activate
    void activate(BundleContext context) throws JMException {
        this.delegate = new DefaultProvisioner((Environment)this.environment, this.resolver, this.repository, this.installer);
    }

    @Override
    public Environment getEnvironment() {
        return this.delegate.getEnvironment();
    }

    @Override
    public Resolver getResolver() {
        return this.delegate.getResolver();
    }

    @Override
    public Repository getRepository() {
        return this.delegate.getRepository();
    }

    @Override
    public ResourceInstaller getResourceInstaller() {
        return this.delegate.getResourceInstaller();
    }

    @Override
    public ProvisionResult findResources(Set<Requirement> reqs) {
        return this.delegate.findResources(reqs);
    }

    @Override
    public Set<ResourceHandle> provisionResources(Set<Requirement> reqs) throws ProvisionException {
        return this.delegate.provisionResources(reqs);
    }

    @Override
    public ResourceHandle installResource(String runtimeName, InputStream inputStream, Dictionary<String, String> headers) throws ProvisionException {
        return this.delegate.installResource(runtimeName, inputStream, headers);
    }

    @Override
    public ResourceHandle installSharedResource(String runtimeName, InputStream inputStream, Dictionary<String, String> headers) throws ProvisionException {
        return this.delegate.installSharedResource(runtimeName, inputStream, headers);
    }

    @Override
    public ResourceHandle installResource(Resource resource, Dictionary<String, String> headers) throws ProvisionException {
        return this.delegate.installResource(resource, headers);
    }

    @Override
    public ResourceHandle installSharedResource(Resource resource, Dictionary<String, String> headers) throws ProvisionException {
        return this.delegate.installSharedResource(resource, headers);
    }

    @Reference
    void bindResolver(Resolver service) {
        this.resolver = service;
    }

    void unbindResolver(Resolver service) {
        this.resolver = null;
    }

    @Reference
    void bindRepository(Repository service) {
        this.repository = service;
    }

    void unbindRepository(Repository service) {
        this.repository = null;
    }

    @Reference
    void bindResourceInstaller(ResourceInstaller service) {
        this.installer = service;
    }

    void unbindResourceInstaller(ResourceInstaller service) {
        this.installer = null;
    }

    @Reference
    void bindRuntimeEnvironment(RuntimeEnvironment service) {
        this.environment = service;
    }

    void unbindRuntimeEnvironment(RuntimeEnvironment service) {
        this.environment = null;
    }
}

