/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.util.Dictionary;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public abstract class AbstractResourceInstaller
implements ResourceInstaller {
    public abstract RuntimeEnvironment getEnvironment();

    @Override
    public ResourceHandle installResource(ResourceInstaller.Context context, Resource res, Dictionary<String, String> headers) throws ProvisionException {
        return this.installResourceInternal(context, res, this.isShared(res), headers);
    }

    @Override
    public ResourceHandle installSharedResource(ResourceInstaller.Context context, Resource res, Dictionary<String, String> headers) throws ProvisionException {
        return this.installResourceInternal(context, res, true, headers);
    }

    private synchronized ResourceHandle installResourceInternal(ResourceInstaller.Context context, Resource resource, boolean shared, Dictionary<String, String> headers) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        if (context == null) {
            context = new DefaultInstallerContext(resource);
        }
        try {
            return this.installResourceProtected(context, resource, shared, headers);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ProvisionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProvisionException("Cannot provision resource: " + resource, ex);
        }
    }

    protected abstract ResourceHandle installResourceProtected(ResourceInstaller.Context var1, Resource var2, boolean var3, Dictionary<String, String> var4) throws Exception;

    private boolean isShared(Resource resource) {
        Object attval = resource.getIdentityCapability().getAttribute("shared");
        return Boolean.parseBoolean((String)attval);
    }
}

