/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceTracker;
import org.jboss.gravia.utils.IllegalStateAssertion;

public class URLStreamHandlerTracker
implements URLStreamHandlerFactory {
    private final Map<String, URLStreamHandlerProxy> handlers = new ConcurrentHashMap<String, URLStreamHandlerProxy>();
    private final ServiceTracker<?, ?> tracker;

    public URLStreamHandlerTracker(ModuleContext context) {
        this.tracker = new ServiceTracker<URLStreamHandler, URLStreamHandler>(context, URLStreamHandler.class, null){

            @Override
            public URLStreamHandler addingService(ServiceReference<URLStreamHandler> sref) {
                URLStreamHandler handler = (URLStreamHandler)super.addingService(sref);
                String protocol = URLStreamHandlerTracker.this.getRequiredProtocol(sref);
                URLStreamHandlerProxy proxy = (URLStreamHandlerProxy)URLStreamHandlerTracker.this.handlers.get(protocol);
                if (proxy == null) {
                    proxy = new URLStreamHandlerProxy(sref, handler);
                    URLStreamHandlerTracker.this.handlers.put(protocol, proxy);
                    URLStreamHandlerTracker.this.addingHandler(protocol, sref, handler);
                } else if (URLStreamHandlerTracker.this.getRanking(proxy.getServiceReference()) < URLStreamHandlerTracker.this.getRanking(sref)) {
                    proxy.update(sref, handler);
                    URLStreamHandlerTracker.this.addingHandler(protocol, sref, handler);
                }
                return handler;
            }

            @Override
            public void removedService(ServiceReference<URLStreamHandler> sref, URLStreamHandler handler) {
                String protocol = URLStreamHandlerTracker.this.getRequiredProtocol(sref);
                URLStreamHandlerProxy proxy = (URLStreamHandlerProxy)URLStreamHandlerTracker.this.handlers.get(protocol);
                if (proxy != null && proxy.getServiceReference().equals(sref)) {
                    URLStreamHandlerTracker.this.removingHandler(protocol, sref, handler);
                    proxy.update(null, null);
                    ServiceReference<S>[] srefs = this.getServiceReferences();
                    if (srefs != null) {
                        for (ServiceReference<URLStreamHandler> serviceReference : srefs) {
                            if (serviceReference == sref || !protocol.equals(URLStreamHandlerTracker.this.getProtocol(serviceReference))) continue;
                            proxy.update(serviceReference, (URLStreamHandler)this.getService(serviceReference));
                            break;
                        }
                    } else {
                        URLStreamHandlerTracker.this.handlers.remove(protocol);
                    }
                }
                super.removedService(sref, handler);
            }
        };
    }

    protected void addingHandler(String protocol, ServiceReference<URLStreamHandler> sref, URLStreamHandler handler) {
    }

    protected void removingHandler(String protocol, ServiceReference<URLStreamHandler> sref, URLStreamHandler handler) {
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.handlers.clear();
        this.tracker.close();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return this.handlers.get(protocol);
    }

    private String getProtocol(ServiceReference<URLStreamHandler> sref) {
        return (String)sref.getProperty("url.handler.protocol");
    }

    private String getRequiredProtocol(ServiceReference<URLStreamHandler> sref) {
        String protocol = this.getProtocol(sref);
        IllegalStateAssertion.assertNotNull((Object)protocol, (String)("Cannot obtain property 'url.handler.protocol' from: " + sref));
        return protocol;
    }

    int getRanking(ServiceReference<?> sref) {
        Integer ranking = (Integer)sref.getProperty("service.ranking");
        return ranking != null ? ranking : 0;
    }

    static class URLStreamHandlerProxy
    extends URLStreamHandler {
        private ServiceReference<URLStreamHandler> sref;
        private URLStreamHandler delegate;

        URLStreamHandlerProxy(ServiceReference<URLStreamHandler> sref, URLStreamHandler delegate) {
            this.update(sref, delegate);
        }

        synchronized void update(ServiceReference<URLStreamHandler> sref, URLStreamHandler delegate) {
            this.delegate = delegate;
            this.sref = sref;
        }

        synchronized URLStreamHandler getDelegate() {
            return this.delegate;
        }

        synchronized ServiceReference<URLStreamHandler> getServiceReference() {
            return this.sref;
        }

        @Override
        protected synchronized URLConnection openConnection(URL url) throws IOException {
            if (this.delegate == null) {
                throw new IOException("URLStreamHandler unregistered");
            }
            return new URL(null, url.toExternalForm(), this.delegate).openConnection();
        }
    }
}

