/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.resource.spi.ResourceLogger;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public abstract class AbstractResourceStore
implements ResourceStore {
    private final String storeName;
    private final Map<ResourceIdentity, Resource> resources = new LinkedHashMap<ResourceIdentity, Resource>();
    private final Map<CacheKey, Set<Capability>> capabilityCache = new ConcurrentHashMap<CacheKey, Set<Capability>>();
    private final MatchPolicy matchPolicy;

    public AbstractResourceStore(String storeName, MatchPolicy matchPolicy) {
        IllegalArgumentAssertion.assertNotNull(storeName, "storeName");
        IllegalArgumentAssertion.assertNotNull(matchPolicy, "matchPolicy");
        this.storeName = storeName;
        this.matchPolicy = matchPolicy;
    }

    @Override
    public String getName() {
        return this.storeName;
    }

    @Override
    public MatchPolicy getMatchPolicy() {
        return this.matchPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Resource> getResources() {
        Iterator itres;
        Map<ResourceIdentity, Resource> map = this.resources;
        synchronized (map) {
            LinkedHashSet<Resource> snapshot = new LinkedHashSet<Resource>(this.resources.values());
            itres = snapshot.iterator();
        }
        return new Iterator<Resource>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Map map = AbstractResourceStore.this.resources;
                synchronized (map) {
                    return itres.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Resource next() {
                Map map = AbstractResourceStore.this.resources;
                synchronized (map) {
                    return (Resource)itres.next();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource addResource(Resource res) {
        Map<ResourceIdentity, Resource> map = this.resources;
        synchronized (map) {
            if (this.getResourceInternal(res.getIdentity()) != null) {
                throw new IllegalArgumentException("Resource already added: " + res);
            }
            ResourceLogger.LOGGER.debug("Add to {}: {}", (Object)this.storeName, (Object)res);
            for (Capability cap : res.getCapabilities(null)) {
                CacheKey cachekey = CacheKey.create(cap);
                this.getCachedCapabilities(cachekey).add(cap);
            }
            if (ResourceLogger.LOGGER.isDebugEnabled()) {
                for (Capability cap : res.getCapabilities(null)) {
                    ResourceLogger.LOGGER.debug("   {}", (Object)cap);
                }
                for (Requirement req : res.getRequirements(null)) {
                    ResourceLogger.LOGGER.debug("   {}", (Object)req);
                }
            }
            this.resources.put(res.getIdentity(), res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource removeResource(ResourceIdentity resid) {
        Map<ResourceIdentity, Resource> map = this.resources;
        synchronized (map) {
            Resource res = this.resources.remove(resid);
            if (res != null) {
                ResourceLogger.LOGGER.debug("Remove from {}: {}", (Object)this.storeName, (Object)res);
                for (Capability cap : res.getCapabilities(null)) {
                    CacheKey cachekey = CacheKey.create(cap);
                    Set<Capability> cachecaps = this.getCachedCapabilities(cachekey);
                    cachecaps.remove(cap);
                    if (!cachecaps.isEmpty()) continue;
                    this.capabilityCache.remove(cachekey);
                }
            }
            return res;
        }
    }

    @Override
    public Resource getResource(ResourceIdentity resid) {
        return this.getResourceInternal(resid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResourceInternal(ResourceIdentity resid) {
        Map<ResourceIdentity, Resource> map = this.resources;
        synchronized (map) {
            return this.resources.get(resid);
        }
    }

    @Override
    public Set<Capability> findProviders(Requirement req) {
        CacheKey cachekey = CacheKey.create(req);
        HashSet<Capability> result = new HashSet<Capability>();
        for (Capability cap : this.findCachedCapabilities(cachekey)) {
            if (!this.matchPolicy.match(cap, req)) continue;
            result.add(cap);
        }
        return Collections.unmodifiableSet(result);
    }

    private synchronized Set<Capability> getCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
            this.capabilityCache.put(key, capset);
        }
        return capset;
    }

    private synchronized Set<Capability> findCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
        }
        if (capset.isEmpty() && key.value == null) {
            for (Map.Entry<CacheKey, Set<Capability>> entry : this.capabilityCache.entrySet()) {
                CacheKey auxkey = entry.getKey();
                if (!auxkey.namespace.equals(key.namespace)) continue;
                capset.addAll((Collection<Capability>)entry.getValue());
            }
        }
        return Collections.unmodifiableSet(capset);
    }

    public String toString() {
        String prefix = this.getClass() != AbstractResourceStore.class ? this.getClass().getSimpleName() : ResourceStore.class.getSimpleName();
        return prefix + "[" + this.storeName + "]";
    }

    private static class CacheKey {
        private final String namespace;
        private final String value;
        private final String keyspec;

        static CacheKey create(Capability cap) {
            String namespace = cap.getNamespace();
            String nsvalue = (String)cap.getAttributes().get(namespace);
            return new CacheKey(namespace, nsvalue);
        }

        static CacheKey create(Requirement req) {
            String namespace = req.getNamespace();
            String nsvalue = (String)req.getAttributes().get(namespace);
            return new CacheKey(namespace, nsvalue);
        }

        private CacheKey(String namespace, String value) {
            this.namespace = namespace;
            this.value = value;
            this.keyspec = namespace + ":" + value;
        }

        public int hashCode() {
            return this.keyspec.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.keyspec.equals(other.keyspec);
        }

        public String toString() {
            return "[" + this.keyspec + "]";
        }
    }
}

