/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.internal.BundleResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class ProvisionerActivator
implements BundleActivator {
    private AtomicReference<ServiceReference<Resolver>> resolverRef = new AtomicReference();
    private AtomicReference<ServiceReference<Repository>> repositoryRef = new AtomicReference();
    private ServiceRegistration<Provisioner> registration;

    public void start(final BundleContext context) throws Exception {
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    ServiceReference sref = event.getServiceReference();
                    String[] objectClass = (String[])sref.getProperty("objectClass");
                    if (Resolver.class.getName().equals(objectClass[0])) {
                        ProvisionerActivator.this.resolverRef.compareAndSet(null, sref);
                        ProvisionerActivator.this.registerProvisionerService(context, this);
                    } else if (Repository.class.getName().equals(objectClass[0])) {
                        ProvisionerActivator.this.repositoryRef.compareAndSet(null, sref);
                        ProvisionerActivator.this.registerProvisionerService(context, this);
                    }
                }
            }
        };
        context.addServiceListener(listener);
        this.resolverRef.compareAndSet(null, (ServiceReference<Resolver>)context.getServiceReference(Resolver.class));
        this.repositoryRef.compareAndSet(null, (ServiceReference<Repository>)context.getServiceReference(Repository.class));
        this.registerProvisionerService(context, listener);
    }

    private synchronized void registerProvisionerService(BundleContext context, ServiceListener listener) {
        ServiceReference<Resolver> resref = this.resolverRef.get();
        ServiceReference<Repository> repref = this.repositoryRef.get();
        if (this.registration == null && resref != null & repref != null) {
            context.removeServiceListener(listener);
            Resolver resolver = (Resolver)context.getService(resref);
            Repository repository = (Repository)context.getService(repref);
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            RuntimeEnvironment environment = new RuntimeEnvironment(runtime).initDefaultContent();
            BundleResourceInstaller installer = new BundleResourceInstaller(context, environment);
            DefaultProvisioner provisioner = new DefaultProvisioner((Environment)environment, resolver, repository, installer);
            this.registration = context.registerService(Provisioner.class, (Object)provisioner, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        ServiceReference<Repository> repref;
        ServiceReference<Resolver> resref;
        if (this.registration != null) {
            this.registration.unregister();
        }
        if ((resref = this.resolverRef.get()) != null) {
            context.ungetService(resref);
        }
        if ((repref = this.repositoryRef.get()) != null) {
            context.ungetService(repref);
        }
    }
}

