/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.DefaultRepositoryXMLWriter;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.repository.RepositoryStorageException;
import org.jboss.gravia.repository.RepositoryWriter;
import org.jboss.gravia.repository.spi.AbstractRepositoryStorage;
import org.jboss.gravia.repository.spi.RepositoryContentHelper;
import org.jboss.gravia.repository.spi.RepositoryLogger;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public class DefaultRepositoryStorage
extends AbstractRepositoryStorage {
    public static final String REPOSITORY_XML_NAME = "repository.xml";
    private final File storageDir;
    private final File repoFile;

    public DefaultRepositoryStorage(PropertiesProvider propertyProvider, Repository repository) {
        super(repository);
        String filename = (String)propertyProvider.getProperty("org.jboss.gravia.repository.storage.file", (Object)REPOSITORY_XML_NAME);
        Path storagePath = DefaultRepositoryStorage.getRepositoryStoragePath(propertyProvider);
        this.storageDir = storagePath.toFile();
        this.repoFile = storagePath.resolve(filename).toFile();
        this.initRepositoryStorage();
    }

    public static Path getRepositoryStoragePath(PropertiesProvider propertyProvider) {
        Runtime runtime = RuntimeLocator.getRuntime();
        String dirname = (String)propertyProvider.getProperty("org.jboss.gravia.repository.storage.dir");
        if (dirname == null && runtime != null) {
            Module sysmodule = runtime.getModuleContext().getModule();
            dirname = sysmodule.getDataFile("repository").getPath();
        }
        if (dirname == null) {
            dirname = Paths.get("repository", new String[0]).toString();
            RepositoryLogger.LOGGER.warn("Cannot obtain repository storage configuration, using: {}", (Object)dirname);
        }
        return Paths.get(dirname, new String[0]);
    }

    @Override
    public RepositoryReader getPersistentRepositoryReader() throws RepositoryStorageException {
        try {
            return this.repoFile.exists() ? new DefaultRepositoryXMLReader(new FileInputStream(this.repoFile)) : null;
        }
        catch (IOException ex) {
            throw new RepositoryStorageException(ex);
        }
    }

    @Override
    public RepositoryWriter getPersistentRepositoryWriter() throws RepositoryStorageException {
        try {
            this.repoFile.getParentFile().mkdirs();
            return new DefaultRepositoryXMLWriter(new FileOutputStream(this.repoFile));
        }
        catch (IOException ex) {
            throw new RepositoryStorageException(ex);
        }
    }

    @Override
    public ResourceBuilder createResourceBuilder() {
        return new DefaultResourceBuilder();
    }

    @Override
    protected void addResourceContent(InputStream input, Map<String, Object> atts) throws RepositoryStorageException {
        try {
            String sha256;
            File tempFile = new File(this.storageDir.getAbsolutePath() + File.separator + "temp-content");
            Long size = this.copyResourceContent(input, tempFile);
            atts.put("size", size);
            String algorithm = "SHA-256";
            try {
                sha256 = RepositoryContentHelper.getDigest(new FileInputStream(tempFile), algorithm);
                atts.put("gravia.content", sha256);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RepositoryStorageException("No such digest algorithm: " + algorithm, ex);
            }
            String contentPath = sha256.substring(0, 2) + File.separator + sha256.substring(2) + File.separator + "content";
            File targetFile = new File(this.storageDir.getAbsolutePath() + File.separator + contentPath);
            targetFile.getParentFile().mkdirs();
            tempFile.renameTo(targetFile);
            URL url = targetFile.toURI().toURL();
            atts.put("url", url);
        }
        catch (IOException ex) {
            throw new RepositoryStorageException(ex);
        }
    }

    @Override
    protected URL getBaseURL() {
        try {
            return this.storageDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private long copyResourceContent(InputStream input, File targetFile) throws IOException {
        int len = 0;
        long total = 0L;
        byte[] buf = new byte[4096];
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(targetFile);
        while ((len = input.read(buf)) >= 0) {
            ((OutputStream)out).write(buf, 0, len);
            total += (long)len;
        }
        input.close();
        ((OutputStream)out).close();
        return total;
    }
}

