/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.spi.ElementParser;

public class DictionaryResourceBuilder
extends DefaultResourceBuilder {
    public DictionaryResourceBuilder load(Dictionary<String, String> headers) {
        boolean identityFound = false;
        Enumeration<String> keys = headers.keys();
        while (keys.hasMoreElements()) {
            String namespace;
            LinkedHashMap<String, String> dirs;
            LinkedHashMap<String, Object> atts;
            String name = keys.nextElement();
            String value = headers.get(name);
            if ("Gravia-Identity".equals(name)) {
                LinkedHashMap<String, Object> atts2 = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> dirs2 = new LinkedHashMap<String, String>();
                String symbolicName = this.parseParameterizedValue(value, atts2, dirs2);
                this.addIdentityCapability(symbolicName, null, atts2, dirs2);
                identityFound = true;
                continue;
            }
            if ("Gravia-IdentityRequirement".equals(name)) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap<String, Object>();
                    dirs = new LinkedHashMap<String, String>();
                    String symbolicName = this.parseParameterizedValue(part, atts, dirs);
                    this.addIdentityRequirement(symbolicName, null, atts, dirs);
                }
                continue;
            }
            if ("Gravia-Capability".equals(name)) {
                for (String part : ElementParser.parseDelimitedString(value, ',')) {
                    atts = new LinkedHashMap();
                    dirs = new LinkedHashMap();
                    namespace = this.parseParameterizedValue(part, atts, dirs);
                    this.addCapability(namespace, atts, dirs);
                }
                continue;
            }
            if (!"Gravia-Requirement".equals(name)) continue;
            for (String part : ElementParser.parseDelimitedString(value, ',')) {
                atts = new LinkedHashMap();
                dirs = new LinkedHashMap();
                namespace = this.parseParameterizedValue(part, atts, dirs);
                this.addRequirement(namespace, atts, dirs);
            }
        }
        if (!identityFound) {
            String symbolicName = null;
            Version version = null;
            keys = headers.keys();
            while (keys.hasMoreElements()) {
                String name = keys.nextElement();
                String value = headers.get(name);
                if (name.equals("Bundle-SymbolicName")) {
                    symbolicName = value;
                    int index = symbolicName.indexOf(59);
                    if (index <= 0) continue;
                    symbolicName = symbolicName.substring(0, index);
                    continue;
                }
                if (!name.equals("Bundle-Version")) continue;
                version = Version.parseVersion(value);
            }
            if (symbolicName != null) {
                this.addIdentityCapability(symbolicName, version);
            }
        }
        return this;
    }
}

