/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.utils.NotNullException;

public enum RuntimeType {
    KARAF,
    TOMCAT,
    WILDFLY,
    OTHER;


    public static RuntimeType getRuntimeType() {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        return RuntimeType.getRuntimeType(runtime);
    }

    public static RuntimeType getRuntimeType(Runtime runtime) {
        NotNullException.assertValue((Object)runtime, (String)"runtime");
        Object type = runtime.getProperty("org.jboss.gravia.runtime.type");
        return RuntimeType.getRuntimeType((String)type);
    }

    public static RuntimeType getRuntimeType(String type) {
        String upper = type != null ? type.toUpperCase() : null;
        try {
            return RuntimeType.valueOf(upper);
        }
        catch (RuntimeException ex) {
            return OTHER;
        }
    }
}

