/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.spi.AbstractEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultMatchPolicy;
import org.jboss.gravia.resource.DefaultResourceStore;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleEvent;
import org.jboss.gravia.runtime.ModuleListener;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.SynchronousModuleListener;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.gravia.utils.NotNullException;

public class RuntimeEnvironment
extends AbstractEnvironment {
    private final ResourceStore systemStore;

    public RuntimeEnvironment(Runtime runtime) {
        this(runtime, (ResourceStore)new DefaultResourceStore("SystemResources"), (MatchPolicy)new DefaultMatchPolicy());
    }

    public RuntimeEnvironment(Runtime runtime, ResourceStore systemStore, MatchPolicy matchPolicy) {
        super(RuntimeEnvironment.class.getSimpleName(), matchPolicy);
        NotNullException.assertValue((Object)runtime, (String)"runtime");
        NotNullException.assertValue((Object)systemStore, (String)"systemStore");
        NotNullException.assertValue((Object)matchPolicy, (String)"matchPolicy");
        this.systemStore = systemStore;
        for (Module module : runtime.getModules()) {
            this.addRuntimeResource((Resource)module.adapt(Resource.class));
        }
        SynchronousModuleListener listener = new SynchronousModuleListener(){

            public void moduleChanged(ModuleEvent event) {
                Module module = event.getModule();
                if (event.getType() == 1) {
                    RuntimeEnvironment.this.addRuntimeResource((Resource)module.adapt(Resource.class));
                } else if (event.getType() == 16) {
                    RuntimeEnvironment.this.removeRuntimeResource(module.getIdentity());
                }
            }
        };
        ModuleContext syscontext = runtime.getModuleContext();
        syscontext.addModuleListener((ModuleListener)listener);
    }

    public static RuntimeEnvironment assertRuntimeEnvironment(Environment env) {
        if (!(env instanceof RuntimeEnvironment)) {
            throw new IllegalArgumentException("Not an RuntimeEnvironment: " + env);
        }
        return (RuntimeEnvironment)env;
    }

    public Iterator<Resource> getRuntimeResources() {
        return super.getResources();
    }

    public Resource addRuntimeResource(Resource resource) {
        return super.addResource(resource);
    }

    public Resource removeRuntimeResource(ResourceIdentity identity) {
        return super.removeResource(identity);
    }

    public ResourceStore getSystemStore() {
        return this.systemStore;
    }

    public RuntimeEnvironment initDefaultContent() {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        File repositoryDir = new File((String)runtime.getProperty("org.jboss.gravia.repository.storage.dir"));
        File environmentXML = new File(repositoryDir, "environment.xml");
        try {
            FileInputStream content = new FileInputStream(environmentXML);
            this.initDefaultContent(content);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeEnvironment initDefaultContent(InputStream content) {
        NotNullException.assertValue((Object)content, (String)"content");
        try {
            DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(content);
            Resource xmlres = reader.nextResource();
            while (xmlres != null) {
                this.systemStore.addResource(xmlres);
                xmlres = reader.nextResource();
            }
        }
        finally {
            IOUtils.safeClose((Closeable)content);
        }
        return this;
    }

    public Resource getResource(ResourceIdentity identity) {
        Resource resource = super.getResource(identity);
        if (resource == null) {
            resource = this.systemStore.getResource(identity);
        }
        return resource;
    }

    public Set<Capability> findProviders(Requirement requirement) {
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(super.findProviders(requirement));
        result.addAll(this.systemStore.findProviders(requirement));
        return Collections.unmodifiableSet(result);
    }

    public Environment cloneEnvironment() {
        return new ClonedRuntimeEnvironment(this);
    }

    public Iterator<Resource> getResources() {
        throw new UnsupportedOperationException();
    }

    public Resource addResource(Resource resource) {
        return this.systemStore.addResource(resource);
    }

    public Resource removeResource(ResourceIdentity identity) {
        return this.systemStore.removeResource(identity);
    }

    static class ClonedRuntimeEnvironment
    extends AbstractEnvironment {
        private final ResourceStore systemStore;

        ClonedRuntimeEnvironment(RuntimeEnvironment environment) {
            super(ClonedRuntimeEnvironment.class.getSimpleName(), environment.getMatchPolicy());
            this.systemStore = environment.getSystemStore();
            Iterator<Resource> itres = environment.getRuntimeResources();
            while (itres.hasNext()) {
                this.addResource(itres.next());
            }
        }

        public Environment cloneEnvironment() {
            throw new UnsupportedOperationException();
        }

        public Resource getResource(ResourceIdentity identity) {
            Resource resource = super.getResource(identity);
            if (resource == null) {
                resource = this.systemStore.getResource(identity);
            }
            return resource;
        }

        public Set<Capability> findProviders(Requirement requirement) {
            LinkedHashSet result = new LinkedHashSet();
            result.addAll(super.findProviders(requirement));
            result.addAll(this.systemStore.findProviders(requirement));
            return Collections.unmodifiableSet(result);
        }
    }
}

