/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.catalina.User;
import org.apache.catalina.ant.DeployTask;
import org.apache.catalina.ant.UndeployTask;
import org.jboss.gravia.container.tomcat.extension.SharedModuleClassLoader;
import org.jboss.gravia.container.tomcat.support.GraviaTomcatLogger;
import org.jboss.gravia.container.tomcat.support.TomcatRuntime;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.AbstractResourceHandle;
import org.jboss.gravia.provision.spi.AbstractResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.NamedResourceAssociation;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.gravia.utils.ResourceUtils;

public class TomcatResourceInstaller
extends AbstractResourceInstaller {
    private final RuntimeEnvironment environment;
    private final TomcatRuntime runtime = (TomcatRuntime)RuntimeLocator.getRequiredRuntime();

    public TomcatResourceInstaller(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    public ResourceHandle installResourceProtected(ResourceInstaller.Context context, Resource resource) throws Exception {
        ResourceHandle handle = ResourceUtils.isShared((Resource)resource) ? this.installSharedResourceInternal(context, resource) : this.installUnsharedResourceInternal(context, resource);
        return handle;
    }

    private ResourceHandle installSharedResourceInternal(ResourceInstaller.Context context, Resource resource) throws Exception {
        GraviaTomcatLogger.LOGGER.info("Installing shared resource: {}", (Object)resource);
        ResourceIdentity resid = resource.getIdentity();
        String symbolicName = resid.getSymbolicName();
        Version version = resid.getVersion();
        Path catalinaLib = this.runtime.getCatalinaHome().resolve("lib");
        final File targetFile = catalinaLib.resolve(symbolicName + "-" + version + ".jar").toFile();
        if (targetFile.exists()) {
            GraviaTomcatLogger.LOGGER.warn("Module already exists: " + targetFile);
        } else {
            ResourceContent content = this.getFirstRelevantResourceContent(resource);
            IOUtils.copyStream((InputStream)content.getContent(), (OutputStream)new FileOutputStream(targetFile));
        }
        final Module module = this.installSharedResource(resource, targetFile);
        module.start();
        final Resource modres = (Resource)module.adapt(Resource.class);
        return new AbstractResourceHandle(modres, module){

            public void uninstall() {
                GraviaTomcatLogger.LOGGER.info("Uninstall shared resource: {}", (Object)modres);
                SharedModuleClassLoader.removeSharedModule((Resource)modres);
                module.uninstall();
                targetFile.delete();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandle installUnsharedResourceInternal(ResourceInstaller.Context context, Resource resource) throws Exception {
        GraviaTomcatLogger.LOGGER.info("Install unshared resource: {}", (Object)resource);
        File tempfile = null;
        ResourceIdentity identity = resource.getIdentity();
        String runtimeName = this.getRuntimeName(resource);
        Path catalinaTemp = this.runtime.getCatalinaHome().resolve("temp");
        ContentCapability ccap = (ContentCapability)resource.getCapabilities("gravia.content").get(0);
        URL contentURL = ccap.getContentURL();
        if (contentURL == null || !contentURL.toExternalForm().startsWith("file:")) {
            ResourceContent content = this.getFirstRelevantResourceContent(resource);
            tempfile = catalinaTemp.resolve(runtimeName).toFile();
            IOUtils.copyStream((InputStream)content.getContent(), (OutputStream)new FileOutputStream(tempfile));
            contentURL = tempfile.toURI().toURL();
        }
        final String contextPath = this.getContextPath(resource);
        final User user = this.runtime.getUserDatabase().findUser("tomcat");
        final String password = user.getPassword();
        NamedResourceAssociation.putResource((String)contextPath, (Resource)resource);
        try {
            DeployTask task = new DeployTask();
            task.setWar(contentURL.toExternalForm());
            task.setUsername(user.getName());
            task.setPassword(password);
            task.setPath(contextPath);
            task.execute();
        }
        finally {
            NamedResourceAssociation.removeResource((String)contextPath);
            if (tempfile != null) {
                tempfile.delete();
            }
        }
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(identity);
        Resource modres = module != null ? (Resource)module.adapt(Resource.class) : resource;
        return new AbstractResourceHandle(modres, module){

            public void uninstall() {
                UndeployTask task = new UndeployTask();
                task.setUsername(user.getName());
                task.setPassword(password);
                task.setPath(contextPath);
                task.execute();
            }
        };
    }

    private Module installSharedResource(Resource resource, File targetFile) throws Exception {
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        for (Capability cap : resource.getCapabilities(null)) {
            String namespace = cap.getNamespace();
            if ("gravia.content".equals(namespace)) continue;
            builder.addCapability(namespace, cap.getAttributes(), cap.getDirectives());
        }
        builder.addContentCapability(targetFile.toURI().toURL());
        for (Requirement req : resource.getRequirements(null)) {
            builder.addRequirement(req.getNamespace(), req.getAttributes(), req.getDirectives());
        }
        resource = builder.getResource();
        SharedModuleClassLoader.addSharedModule((Resource)resource);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ClassLoader classLoader = SharedModuleClassLoader.class.getClassLoader();
        return runtime.installModule(classLoader, resource, null);
    }

    private String getContextPath(Resource res) {
        String contextPath = (String)res.getIdentityCapability().getAttribute("contextPath");
        if (contextPath == null) {
            contextPath = res.getIdentity().getSymbolicName();
        }
        return "/" + contextPath;
    }
}

