/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.net.URLStreamHandlerFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.jboss.gravia.container.tomcat.support.ServletContextEntriesProvider;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.URLStreamHandlerTracker;
import org.jboss.gravia.utils.IllegalStateAssertion;

public class TomcatRuntime
extends EmbeddedRuntime {
    public static final String TOMCAT_USER = "tomcat";
    private final UserDatabase userDatabase;

    public TomcatRuntime(PropertiesProvider propertiesProvider, Attachable context) {
        super(propertiesProvider, context);
        URLStreamHandlerTracker tracker = new URLStreamHandlerTracker(this.getModuleContext());
        DirContextURLStreamHandlerFactory.addUserFactory((URLStreamHandlerFactory)tracker);
        tracker.open();
        try {
            this.userDatabase = new MemoryUserDatabase();
            this.userDatabase.open();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot open user database", ex);
        }
        IllegalStateAssertion.assertNotNull((Object)this.userDatabase.findUser(TOMCAT_USER), (String)"Cannot obtain user: tomcat");
    }

    protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
        ServletContext servletContext = (ServletContext)context.getAttachment(WebAppContextListener.SERVLET_CONTEXT_KEY);
        return servletContext != null ? new ServletContextEntriesProvider(servletContext) : null;
    }

    public Path getCatalinaHome() {
        return Paths.get((String)this.getProperty("catalina.home"), new String[0]);
    }

    public UserDatabase getUserDatabase() {
        return this.userDatabase;
    }
}

