/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.webapp;

import java.io.File;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.gravia.container.tomcat.extension.TomcatRuntimeFactory;
import org.jboss.gravia.container.tomcat.webapp.SecurityActions;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.embedded.spi.BundleContextAdaptor;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.util.DefaultPropertiesProvider;

@WebListener
public class GraviaActivator
implements ServletContextListener {
    private static final File catalinaHome = new File(SecurityActions.getSystemProperty((String)"catalina.home", null));

    public void contextInitialized(ServletContextEvent event) {
        Properties sysprops = this.getRuntimeProperties();
        DefaultPropertiesProvider propsProvider = new DefaultPropertiesProvider(sysprops, true);
        Runtime runtime = RuntimeLocator.createRuntime((RuntimeFactory)new TomcatRuntimeFactory(), (PropertiesProvider)propsProvider);
        runtime.init();
        ServletContext servletContext = event.getServletContext();
        ModuleContext moduleContext = runtime.getModule(0L).getModuleContext();
        BundleContextAdaptor bundleContext = new BundleContextAdaptor(moduleContext);
        servletContext.setAttribute("org.osgi.framework.BundleContext", (Object)bundleContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private Properties getRuntimeProperties() {
        File catalinaWork = new File(catalinaHome.getPath() + File.separator + "work");
        File storageDir = new File(catalinaWork.getPath() + File.separator + "gravia-store");
        Properties properties = new Properties();
        properties.setProperty("org.jboss.gravia.runtime.storage.clean", "onFirstInit");
        properties.setProperty("org.jboss.gravia.runtime.storage", storageDir.getAbsolutePath());
        properties.setProperty("org.jboss.gravia.runtime.type", "tomcat");
        return properties;
    }
}

