/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.webapp;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.gravia.container.common.ActivationSupport;
import org.jboss.gravia.container.tomcat.support.TomcatPropertiesProvider;
import org.jboss.gravia.container.tomcat.support.TomcatResourceInstaller;
import org.jboss.gravia.container.tomcat.support.TomcatRuntimeFactory;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.repository.DefaultRepository;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryRuntimeRegistration;
import org.jboss.gravia.resolver.DefaultResolver;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.spi.RuntimePropertiesProvider;

@WebListener
public class GraviaTomcatActivator
implements ServletContextListener {
    private RepositoryRuntimeRegistration.Registration repositoryRegistration;
    private ServiceRegistration<Provisioner> provisionerRegistration;
    private ServiceRegistration<Resolver> resolverRegistration;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        TomcatPropertiesProvider propsProvider = new TomcatPropertiesProvider(servletContext);
        Runtime runtime = RuntimeLocator.createRuntime((RuntimeFactory)new TomcatRuntimeFactory(servletContext), (PropertiesProvider)propsProvider);
        runtime.init();
        Object configsDir = propsProvider.getProperty("org.jboss.gravia.configurations.dir");
        ActivationSupport.initConfigurationAdmin((File)new File((String)configsDir));
        Repository repository = this.registerRepositoryService(runtime);
        Resolver resolver = this.registerResolverService(runtime);
        this.registerProvisionerService(servletContext, runtime, repository, resolver);
    }

    private Provisioner registerProvisionerService(ServletContext servletContext, Runtime runtime, Repository repository, Resolver resolver) {
        RuntimeEnvironment environment = this.createEnvironment(servletContext, runtime);
        TomcatResourceInstaller installer = new TomcatResourceInstaller(environment);
        DefaultProvisioner provisioner = new DefaultProvisioner((Environment)environment, resolver, repository, (ResourceInstaller)installer);
        ModuleContext syscontext = runtime.getModuleContext();
        this.provisionerRegistration = syscontext.registerService(Provisioner.class, (Object)provisioner, null);
        return provisioner;
    }

    private RuntimeEnvironment createEnvironment(ServletContext servletContext, Runtime runtime) {
        return new RuntimeEnvironment(runtime).initDefaultContent();
    }

    private Resolver registerResolverService(Runtime runtime) {
        DefaultResolver resolver = new DefaultResolver();
        ModuleContext syscontext = runtime.getModuleContext();
        this.resolverRegistration = syscontext.registerService(Resolver.class, (Object)resolver, null);
        return resolver;
    }

    private Repository registerRepositoryService(Runtime runtime) {
        RuntimePropertiesProvider propertyProvider = new RuntimePropertiesProvider(runtime);
        DefaultRepository repository = new DefaultRepository((PropertiesProvider)propertyProvider);
        ModuleContext syscontext = runtime.getModuleContext();
        this.repositoryRegistration = RepositoryRuntimeRegistration.registerRepository((ModuleContext)syscontext, (Repository)repository);
        return repository;
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.provisionerRegistration != null) {
            this.provisionerRegistration.unregister();
        }
        if (this.repositoryRegistration != null) {
            this.repositoryRegistration.unregister();
        }
        if (this.resolverRegistration != null) {
            this.resolverRegistration.unregister();
        }
    }
}

