/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.server.Services;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.DefaultResourceHandle;
import org.jboss.gravia.provision.Environment;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryContent;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.gravia.GraviaConstants;

public class ProvisionerService
extends AbstractService<Provisioner> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)GraviaConstants.class.getPackage().getName());
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<Environment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<Repository> injectedRepository = new InjectedValue();
    private final InjectedValue<Resolver> injectedResolver = new InjectedValue();
    private ServerDeploymentManager serverDeploymentManager;
    private ModelControllerClient modelControllerClient;
    private Provisioner provisioner;

    public static ServiceController<Provisioner> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ProvisionerService service = new ProvisionerService();
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.PROVISIONER_SERVICE_NAME, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedController);
        builder.addDependency(GraviaConstants.ENVIRONMENT_SERVICE_NAME, Environment.class, service.injectedEnvironment);
        builder.addDependency(GraviaConstants.REPOSITORY_SERVICE_NAME, Repository.class, service.injectedRepository);
        builder.addDependency(GraviaConstants.RESOLVER_SERVICE_NAME, Resolver.class, service.injectedResolver);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private ProvisionerService() {
    }

    public void start(StartContext startContext) throws StartException {
        ModelController modelController = (ModelController)this.injectedController.getValue();
        this.modelControllerClient = modelController.createClient((Executor)Executors.newCachedThreadPool());
        this.serverDeploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient);
        Resolver resolver = (Resolver)this.injectedResolver.getValue();
        Repository repository = (Repository)this.injectedRepository.getValue();
        this.provisioner = new DefaultProvisioner(resolver, repository){

            protected Environment createEnvironment() {
                return (Environment)ProvisionerService.this.injectedEnvironment.getValue();
            }

            public Provisioner.ResourceHandle installResource(Resource resource, Map<Requirement, Resource> mapping) throws ProvisionException {
                return ProvisionerService.this.installResourceInternal(resource, mapping);
            }
        };
    }

    public void stop(StopContext context) {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Provisioner getValue() throws IllegalStateException {
        return this.provisioner;
    }

    private Provisioner.ResourceHandle installResourceInternal(Resource res, Map<Requirement, Resource> mapping) throws ProvisionException {
        RepositoryContent content = (RepositoryContent)res.adapt(RepositoryContent.class);
        if (content == null) {
            return new DefaultResourceHandle(res);
        }
        final String runtimeName = res.getIdentity().getSymbolicName();
        final ServerDeploymentHelper serverDeployer = new ServerDeploymentHelper(this.serverDeploymentManager);
        try {
            InputStream input = this.getWrappedResourceContent(res, mapping);
            serverDeployer.deploy(runtimeName, input);
        }
        catch (Throwable th) {
            throw new ProvisionException("Cannot provision resource: " + res, th);
        }
        return new DefaultResourceHandle(res){

            public void uninstall() throws ProvisionException {
                try {
                    serverDeployer.undeploy(runtimeName);
                }
                catch (Throwable th) {
                    throw new ProvisionException("Cannot uninstall provisioned resource: " + this.getResource(), th);
                }
            }
        };
    }

    private InputStream getWrappedResourceContent(Resource res, Map<Requirement, Resource> mapping) {
        ResourceIdentity resid = res.getIdentity();
        ConfigurationBuilder config = new ConfigurationBuilder().classLoaders(Collections.singleton(ShrinkWrap.class.getClassLoader()));
        JavaArchive archive = (JavaArchive)ShrinkWrap.createDomain((ConfigurationBuilder)config).getArchiveFactory().create(JavaArchive.class, "wrapped-resource.jar");
        ((ZipImporter)archive.as(ZipImporter.class)).importFrom(((RepositoryContent)res).getContent());
        JavaArchive wrapper = (JavaArchive)ShrinkWrap.createDomain((ConfigurationBuilder)config).getArchiveFactory().create(JavaArchive.class, "wrapped:" + resid.getSymbolicName());
        wrapper.addAsManifestResource(this.getDeploymentStructureAsset(res, mapping), "jboss-deployment-structure.xml");
        wrapper.add((Archive)archive, "/", ZipExporter.class);
        return ((ZipExporter)wrapper.as(ZipExporter.class)).exportAsInputStream();
    }

    private Asset getDeploymentStructureAsset(Resource res, Map<Requirement, Resource> mapping) {
        LOGGER.info("Generating dependencies for: {}", (Object)res);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<jboss-deployment-structure xmlns='urn:jboss:deployment-structure:1.2'>");
        buffer.append(" <deployment>");
        buffer.append("  <resources>");
        buffer.append("   <resource-root path='wrapped-resource.jar' use-physical-code-source='true'/>");
        buffer.append("  </resources>");
        buffer.append("  <dependencies>");
        for (Requirement req : res.getRequirements("gravia.identity")) {
            Resource depres = mapping.get(req);
            if (depres == null) continue;
            Capability icap = depres.getIdentityCapability();
            String type = (String)icap.getAttribute("type");
            String modname = depres.getIdentity().getSymbolicName();
            if (!"jboss.module".equals(type)) {
                modname = "deployment." + modname;
            }
            buffer.append("<module name='" + modname + "'/>");
            LOGGER.info("  {}", (Object)modname);
        }
        buffer.append("  </dependencies>");
        buffer.append(" </deployment>");
        buffer.append("</jboss-deployment-structure>");
        return new StringAsset(buffer.toString());
    }
}

