/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.parser;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.gravia.deployment.GraviaServicesProcessor;
import org.wildfly.extension.gravia.deployment.ManifestResourceProcessor;
import org.wildfly.extension.gravia.deployment.ModuleInstallProcessor;
import org.wildfly.extension.gravia.deployment.ModuleStartProcessor;
import org.wildfly.extension.gravia.parser.SubsystemState;
import org.wildfly.extension.gravia.service.EnvironmentService;
import org.wildfly.extension.gravia.service.GraviaBootstrapService;
import org.wildfly.extension.gravia.service.ModuleContextService;
import org.wildfly.extension.gravia.service.ProvisionerService;
import org.wildfly.extension.gravia.service.RepositoryService;
import org.wildfly.extension.gravia.service.ResolverService;
import org.wildfly.extension.gravia.service.RuntimeService;

final class GraviaSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final int PARSE_GRAVIA_SERVICES_PROVIDER = 14337;
    public static final int PARSE_GRAVIA_RESOURCE = 14081;
    public static final int POST_MODULE_GRAVIA_MODULE_INSTALL = 513;
    public static final int INSTALL_GRAVIA_MODULE_START = 8289;

    public GraviaSubsystemAdd(SubsystemState subsystemState) {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.add(new GraviaBootstrapService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new EnvironmentService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new ModuleContextService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new ResolverService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new RepositoryService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new ProvisionerService().install(context.getServiceTarget(), verificationHandler));
                newControllers.add(new RuntimeService().install(context.getServiceTarget(), verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("gravia", Phase.PARSE, 14337, (DeploymentUnitProcessor)new GraviaServicesProcessor());
                processorTarget.addDeploymentProcessor("gravia", Phase.PARSE, 14081, (DeploymentUnitProcessor)new ManifestResourceProcessor());
                processorTarget.addDeploymentProcessor("gravia", Phase.POST_MODULE, 513, (DeploymentUnitProcessor)new ModuleInstallProcessor());
                processorTarget.addDeploymentProcessor("gravia", Phase.INSTALL, 8289, (DeploymentUnitProcessor)new ModuleStartProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

