/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.NotNullException;
import org.jboss.vfs.VirtualFile;

public class VirtualFileEntriesProvider
implements ModuleEntriesProvider {
    private final VirtualFile rootFile;

    public VirtualFileEntriesProvider(ResourceRoot resourceRoot) {
        NotNullException.assertValue((Object)resourceRoot, (String)"resourceRoot");
        this.rootFile = resourceRoot.getRoot();
    }

    public URL getEntry(String path) {
        try {
            VirtualFile child = this.rootFile.getChild(path);
            return child.asFileURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Enumeration<String> getEntryPaths(String path) {
        VirtualFile pathChild = this.rootFile.getChild(path);
        List entries = pathChild.getChildren();
        if (entries.isEmpty()) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        for (VirtualFile entry : entries) {
            result.add(entry.getPathName());
        }
        return result.elements();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (filePattern.contains("*") || recurse) {
            throw new UnsupportedOperationException("Bundle.getEntryPaths(String,String,boolean)");
        }
        VirtualFile pathChild = this.rootFile.getChild(path);
        List entries = pathChild.getChildren();
        if (entries.isEmpty()) {
            return null;
        }
        Vector<URL> result = this.getResultVector(entries, filePattern);
        return result.elements();
    }

    private Vector<URL> getResultVector(List<VirtualFile> entries, String filePattern) {
        Vector<URL> result = new Vector<URL>();
        Pattern pattern = VirtualFileEntriesProvider.convertToPattern(filePattern);
        for (VirtualFile vfile : entries) {
            int lastIndex;
            String filename;
            String resname = vfile.getPathName();
            if (resname.startsWith("/")) {
                resname = resname.substring(1);
            }
            if (!pattern.matcher(filename = (lastIndex = resname.lastIndexOf(47)) > 0 ? resname.substring(lastIndex + 1) : resname).matches()) continue;
            try {
                result.add(vfile.asFileURL());
            }
            catch (MalformedURLException e) {}
        }
        return result;
    }

    private static Pattern convertToPattern(String filePattern) {
        filePattern = filePattern.replace("*", ".*");
        return Pattern.compile("^" + filePattern + "$");
    }
}

