/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.resource.DictionaryResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.util.CaseInsensitiveDictionary;
import org.jboss.gravia.runtime.util.NotNullException;
import org.jboss.gravia.runtime.util.UnmodifiableDictionary;
import org.jboss.logging.Logger;

public abstract class AbstractModule
implements Module,
Attachable {
    public static Logger LOGGER = Logger.getLogger((String)Module.class.getPackage().getName());
    private final AbstractRuntime runtime;
    private final ClassLoader classLoader;
    private final Resource resource;
    private final Dictionary<String, String> headers;
    private final Attachable attachments = new AttachableSupport();
    private final ConcurrentHashMap<ServiceReference<?>, AtomicInteger> usedServices = new ConcurrentHashMap();

    protected AbstractModule(AbstractRuntime runtime, ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        NotNullException.assertValue(runtime, "runtime");
        NotNullException.assertValue(classLoader, "classLoader");
        this.runtime = runtime;
        this.classLoader = classLoader;
        if (resource == null && headers == null) {
            throw new IllegalArgumentException("Cannot create module identity");
        }
        if (resource == null) {
            DictionaryResourceBuilder builder = new DictionaryResourceBuilder().load(headers);
            resource = builder.getResource();
        }
        this.resource = resource;
        ResourceIdentity resourceIdentity = resource.getIdentity();
        if (headers == null) {
            headers = new Hashtable<String, String>();
            String identityHeader = this.getIdentityHeader(resourceIdentity);
            headers.put("Gravia-Identity", identityHeader);
        }
        this.headers = new UnmodifiableDictionary<String, String>(new CaseInsensitiveDictionary<String>(headers));
        ResourceIdentity headersIdentity = new DictionaryResourceBuilder().load(headers).getResource().getIdentity();
        if (!resourceIdentity.equals((Object)headersIdentity)) {
            throw new IllegalArgumentException("Resource and header identity does not match: " + resourceIdentity);
        }
    }

    private String getIdentityHeader(ResourceIdentity identity) {
        String symbolicName = identity.getSymbolicName();
        Version version = identity.getVersion();
        return symbolicName + ";version=" + version;
    }

    protected abstract void setState(Module.State var1);

    protected AbstractRuntime getRuntime() {
        return this.runtime;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceIdentity getIdentity() {
        return this.resource.getIdentity();
    }

    @Override
    public <A> A adapt(Class<A> type) {
        Object result = null;
        if (type.isAssignableFrom(Runtime.class)) {
            result = this.runtime;
        } else if (type.isAssignableFrom(AbstractRuntime.class)) {
            result = this.runtime;
        } else if (type.isAssignableFrom(ClassLoader.class)) {
            result = this.classLoader;
        } else if (type.isAssignableFrom(Resource.class)) {
            result = this.resource;
        } else if (type.isAssignableFrom(Module.class)) {
            result = this;
        } else if (type.isAssignableFrom(ModuleContext.class)) {
            result = this.getModuleContext();
        }
        return (A)result;
    }

    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return (T)this.attachments.putAttachment(key, value);
    }

    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)this.attachments.getAttachment(key);
    }

    public <T> T removeAttachment(AttachmentKey<T> key) {
        return (T)this.attachments.removeAttachment(key);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        this.assertNotUninstalled();
        return this.classLoader.loadClass(className);
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    public Set<ServiceReference<?>> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    public void addServiceInUse(ServiceReference<?> serviceState) {
        LOGGER.tracef("Add service in use %s to: %s", serviceState, (Object)this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    public int removeServiceInUse(ServiceReference<?> serviceState) {
        LOGGER.tracef("Remove service in use %s from: %s", serviceState, (Object)this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    protected void assertNotUninstalled() {
        if (this.getState() == Module.State.UNINSTALLED) {
            throw new IllegalStateException("Module already uninstalled: " + this);
        }
    }

    public String toString() {
        return "Module[" + this.getIdentity() + "]";
    }
}

