/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.util;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public final class DefaultPropertiesProvider
implements PropertiesProvider {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public DefaultPropertiesProvider() {
        this(System.getProperties());
    }

    public DefaultPropertiesProvider(Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public DefaultPropertiesProvider(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                this.properties.put(key, value);
            }
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }
}

