/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.util.SecurityActions;
import org.jboss.gravia.utils.NotNullException;

public final class DefaultPropertiesProvider
implements PropertiesProvider {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public DefaultPropertiesProvider() {
        URL configURL = null;
        String sysprop = System.getProperty("gravia.properties");
        if (sysprop != null) {
            try {
                configURL = new URL(sysprop);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Invalid configuration URL: " + sysprop);
            }
        }
        if (configURL == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            configURL = classLoader.getResource("gravia.properties");
        }
        if (configURL != null) {
            Properties props = new Properties();
            try {
                props.load(configURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load configuration from: " + configURL, ex);
            }
            this.propsToMap(this.properties, props);
        }
    }

    public DefaultPropertiesProvider(Map<String, Object> props) {
        NotNullException.assertValue(props, (String)"props");
        this.properties.putAll(props);
    }

    public DefaultPropertiesProvider(Properties props) {
        NotNullException.assertValue((Object)props, (String)"props");
        this.propsToMap(this.properties, props);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propsToMap(Map<String, Object> target, Properties props) {
        Properties properties = props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                target.put(key, value);
            }
        }
    }
}

