/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SecurityActions;
import org.jboss.gravia.utils.IllegalStateAssertion;

public class EnvPropertiesProvider
implements PropertiesProvider {
    public static final String DEFAULT_ENV_PREFIX = "GRAVIA_";
    private static final String ENV_REPLACE_PATTERN = "-|\\.";
    private final String environmentVariablePrefix;

    public EnvPropertiesProvider() {
        this(DEFAULT_ENV_PREFIX);
    }

    public EnvPropertiesProvider(String environmentVariablePrefix) {
        this.environmentVariablePrefix = environmentVariablePrefix != null ? environmentVariablePrefix : DEFAULT_ENV_PREFIX;
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getRequiredProperty(String key) {
        Object value = this.getProperty(key, null);
        IllegalStateAssertion.assertNotNull((Object)value, (String)("Cannot obtain property: " + key));
        return value;
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        String envVar = SecurityActions.getEnv(EnvPropertiesProvider.toEnvVariable(this.environmentVariablePrefix, key), null);
        return envVar != null ? envVar : defaultValue;
    }

    private static String toEnvVariable(String prefix, String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return prefix + name.replaceAll(ENV_REPLACE_PATTERN, "_").toUpperCase();
    }
}

