/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.gravia.runtime.spi.AbstractPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;

public class SubstitutionPropertiesProvider
extends AbstractPropertiesProvider {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9\\.\\-]+)}");
    private static final String BOX_FORMAT = "\\$\\{%s\\}";
    private final PropertiesProvider delegate;

    public SubstitutionPropertiesProvider(PropertiesProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object rawValue = this.delegate.getProperty(key, defaultValue);
        if (rawValue == null) {
            return defaultValue;
        }
        return SubstitutionPropertiesProvider.substitute(String.valueOf(rawValue), this.delegate, new HashSet<String>());
    }

    private static String substitute(String str, PropertiesProvider provider, Set<String> visited) {
        String result = str;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        CopyOnWriteArraySet<String> copyOfVisited = new CopyOnWriteArraySet<String>(visited);
        while (matcher.find()) {
            String name = matcher.group(1);
            String replacement = "";
            String toReplace = String.format(BOX_FORMAT, name);
            if (provider.getProperty(name) != null && !visited.contains(name)) {
                replacement = String.valueOf(provider.getProperty(name));
                String string = replacement = replacement != null ? replacement : "";
                if (PLACEHOLDER_PATTERN.matcher(replacement).matches()) {
                    copyOfVisited.add(name);
                    replacement = SubstitutionPropertiesProvider.substitute(replacement, provider, copyOfVisited);
                }
            }
            result = result.replaceAll(toReplace, Matcher.quoteReplacement(replacement));
        }
        return result;
    }
}

