/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleActivator;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedModuleContext;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedRuntime;
import org.jboss.gravia.runtime.embedded.internal.RuntimeStorageHandler;
import org.jboss.gravia.runtime.embedded.spi.BundleAdaptor;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.osgi.framework.Bundle;

final class EmbeddedModule
extends AbstractModule {
    private static AttachmentKey<ModuleActivator> MODULE_ACTIVATOR_KEY = AttachmentKey.create(ModuleActivator.class);
    private static final AtomicLong moduleIdGenerator = new AtomicLong();
    private static final Long START_STOP_TIMEOUT = new Long(10000L);
    private final AtomicReference<Module.State> stateRef = new AtomicReference();
    private final AtomicReference<ModuleContext> contextRef = new AtomicReference();
    private final ReentrantLock startStopLock = new ReentrantLock();
    private final long moduleId = moduleIdGenerator.incrementAndGet();

    EmbeddedModule(EmbeddedRuntime runtime, ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        super((AbstractRuntime)runtime, classLoader, resource, headers);
        this.stateRef.set(Module.State.UNINSTALLED);
    }

    public <A> A adapt(Class<A> type) {
        Object result = super.adapt(type);
        if (result == null && type.isAssignableFrom(EmbeddedRuntime.class)) {
            result = this.getRuntime();
        }
        return (A)result;
    }

    public long getModuleId() {
        return this.moduleId;
    }

    public ModuleContext getModuleContext() {
        return this.contextRef.get();
    }

    private void createModuleContext() {
        this.contextRef.set((ModuleContext)new EmbeddedModuleContext((Module)this));
    }

    private void destroyModuleContext() {
        EmbeddedModuleContext context = (EmbeddedModuleContext)this.contextRef.get();
        if (context != null) {
            context.destroy();
        }
        this.contextRef.set(null);
    }

    public Module.State getState() {
        return this.stateRef.get();
    }

    public void setState(Module.State newState) {
        this.stateRef.set(newState);
    }

    protected Bundle getBundleAdaptor(Module module) {
        return new BundleAdaptor((Module)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ModuleException {
        this.assertNotUninstalled();
        try {
            RuntimeEventsManager eventHandler;
            block15: {
                if (!this.startStopLock.tryLock(START_STOP_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    throw new ModuleException("Cannot aquire start lock for: " + (Object)((Object)this));
                }
                if (this.getState() == Module.State.ACTIVE) {
                    RuntimeLogger.LOGGER.debug("Already active: {}", (Object)this);
                    return;
                }
                this.setState(Module.State.STARTING);
                eventHandler = this.getRuntime().adapt(RuntimeEventsManager.class);
                eventHandler.fireModuleEvent((Module)this, 128);
                this.createModuleContext();
                try {
                    ModuleActivator moduleActivator;
                    String className = (String)this.getHeaders().get("Module-Activator");
                    if (className == null) break block15;
                    AttachmentKey<ModuleActivator> attachmentKey = MODULE_ACTIVATOR_KEY;
                    synchronized (attachmentKey) {
                        moduleActivator = (ModuleActivator)this.getAttachment(MODULE_ACTIVATOR_KEY);
                        if (moduleActivator == null) {
                            Object result = this.loadClass(className).newInstance();
                            moduleActivator = (ModuleActivator)result;
                            this.putAttachment(MODULE_ACTIVATOR_KEY, moduleActivator);
                        }
                    }
                    if (moduleActivator != null) {
                        moduleActivator.start(this.getModuleContext());
                    }
                }
                catch (Throwable th) {
                    this.setState(Module.State.STOPPING);
                    eventHandler.fireModuleEvent((Module)this, 256);
                    this.setState(Module.State.INSTALLED);
                    eventHandler.fireModuleEvent((Module)this, 4);
                    this.destroyModuleContext();
                    throw new ModuleException("Cannot start module: " + (Object)((Object)this), th);
                }
            }
            this.setState(Module.State.ACTIVE);
            eventHandler.fireModuleEvent((Module)this, 2);
            RuntimeLogger.LOGGER.info("Started: {}", (Object)this);
        }
        catch (InterruptedException ex) {
            throw ModuleException.launderThrowable((Throwable)ex);
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void stop() throws ModuleException {
        this.assertNotUninstalled();
        try {
            if (!this.startStopLock.tryLock(START_STOP_TIMEOUT, TimeUnit.MILLISECONDS)) {
                throw new ModuleException("Cannot aquire stop lock for: " + (Object)((Object)this));
            }
            if (this.getState() != Module.State.ACTIVE) {
                return;
            }
            this.setState(Module.State.STOPPING);
            RuntimeEventsManager eventHandler = this.getRuntime().adapt(RuntimeEventsManager.class);
            eventHandler.fireModuleEvent((Module)this, 256);
            Throwable stopException = null;
            try {
                ModuleActivator moduleActivator = (ModuleActivator)this.getAttachment(MODULE_ACTIVATOR_KEY);
                if (moduleActivator != null) {
                    moduleActivator.stop(this.getModuleContext());
                }
            }
            catch (Throwable th) {
                stopException = th;
            }
            this.setState(Module.State.INSTALLED);
            eventHandler.fireModuleEvent((Module)this, 4);
            this.destroyModuleContext();
            if (stopException != null) {
                throw new ModuleException("Cannot stop module: " + (Object)((Object)this), stopException);
            }
            RuntimeLogger.LOGGER.info("Stopped: {}", (Object)this);
        }
        catch (InterruptedException ex) {
            throw ModuleException.launderThrowable((Throwable)ex);
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void uninstall() {
        this.assertNotUninstalled();
        try {
            this.stop();
        }
        catch (Exception ex) {
            RuntimeLogger.LOGGER.error("Cannot stop module on uninstall: " + (Object)((Object)this), (Throwable)ex);
        }
        this.setState(Module.State.UNINSTALLED);
        RuntimeEventsManager eventHandler = this.getRuntime().adapt(RuntimeEventsManager.class);
        eventHandler.fireModuleEvent((Module)this, 16);
        this.getRuntime().uninstallModule((Module)this);
    }

    public File getDataFile(String filename) {
        this.assertNotUninstalled();
        RuntimeStorageHandler storageHandler = this.getStorageHandler();
        return storageHandler.getDataFile((Module)this, filename);
    }

    protected EmbeddedRuntime getRuntime() {
        return (EmbeddedRuntime)super.getRuntime();
    }

    private RuntimeStorageHandler getStorageHandler() {
        AbstractRuntime runtime = this.adapt(AbstractRuntime.class);
        return (RuntimeStorageHandler)runtime.adapt(RuntimeStorageHandler.class);
    }
}

