/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.gravia.runtime.Filter;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceFactory;
import org.jboss.gravia.runtime.embedded.internal.ServiceReferenceComparator;
import org.jboss.gravia.runtime.embedded.internal.ServiceState;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.NoFilter;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;

final class RuntimeServicesManager {
    private final RuntimeEventsManager frameworkEvents;
    private final Map<String, List<ServiceState<?>>> serviceMap = new ConcurrentHashMap();
    private final AtomicLong identityGenerator = new AtomicLong();

    RuntimeServicesManager(RuntimeEventsManager frameworkEvents) {
        this.frameworkEvents = frameworkEvents;
    }

    void fireServiceEvent(Module module, int type, ServiceState<?> serviceState) {
        this.frameworkEvents.fireServiceEvent(module, type, serviceState);
    }

    private long getNextServiceId() {
        return this.identityGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceState registerService(ModuleContext context, String[] classNames, final Object serviceValue, Dictionary properties) {
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        ServiceState.ValueProvider<Object> valueProvider = new ServiceState.ValueProvider<Object>(){

            @Override
            public boolean isFactoryValue() {
                return serviceValue instanceof ServiceFactory;
            }

            @Override
            public Object getValue() {
                return serviceValue;
            }
        };
        long serviceId = this.getNextServiceId();
        ServiceState<Object> serviceState = new ServiceState<Object>(this, context.getModule(), serviceId, classNames, valueProvider, properties);
        RuntimeLogger.LOGGER.debug("Register service: {}", serviceState);
        for (String className : classNames) {
            List<ServiceState<?>> serviceStates;
            Map<String, List<ServiceState<?>>> map = this.serviceMap;
            synchronized (map) {
                serviceStates = this.serviceMap.get(className);
                if (serviceStates == null) {
                    serviceStates = new CopyOnWriteArrayList();
                    this.serviceMap.put(className, serviceStates);
                }
            }
            serviceStates.add(serviceState);
        }
        this.frameworkEvents.fireServiceEvent(context.getModule(), 1, serviceState);
        return serviceState;
    }

    ServiceState<?> getServiceReference(ModuleContext context, String clazz) {
        assert (clazz != null) : "Null clazz";
        List<ServiceState<?>> result = this.getServiceReferencesInternal(context, clazz, NoFilter.INSTANCE, true);
        if (result.isEmpty()) {
            return null;
        }
        int lastIndex = result.size() - 1;
        return result.get(lastIndex);
    }

    List<ServiceState<?>> getServiceReferences(ModuleContext context, String clazz, String filterStr, boolean checkAssignable) {
        Filter filter = NoFilter.INSTANCE;
        if (filterStr != null) {
            filter = context.createFilter(filterStr);
        }
        List<ServiceState<?>> result = this.getServiceReferencesInternal(context, clazz, filter, checkAssignable);
        return result;
    }

    private List<ServiceState<?>> getServiceReferencesInternal(ModuleContext module, String className, Filter filter, boolean checkAssignable) {
        assert (module != null) : "Null module";
        assert (filter != null) : "Null filter";
        HashSet initialSet = new HashSet();
        if (className != null) {
            List<ServiceState<?>> list = this.serviceMap.get(className);
            if (list != null) {
                initialSet.addAll(list);
            }
        } else {
            for (List<ServiceState<?>> list : this.serviceMap.values()) {
                initialSet.addAll(list);
            }
        }
        if (initialSet.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceState> resultset = new HashSet<ServiceState>();
        for (ServiceState serviceState : initialSet) {
            if (!this.isMatchingService(module, serviceState, className, filter, checkAssignable)) continue;
            resultset.add(serviceState);
        }
        ArrayList resultList = new ArrayList(resultset);
        if (resultList.size() > 1) {
            Collections.sort(resultList, ServiceReferenceComparator.getInstance());
        }
        return Collections.unmodifiableList(resultList);
    }

    private boolean isMatchingService(ModuleContext context, ServiceState<?> serviceState, String clazzName, Filter filter, boolean checkAssignable) {
        if (serviceState.isUnregistered() || !filter.match(serviceState)) {
            return false;
        }
        if (!checkAssignable || clazzName == null) {
            return true;
        }
        return serviceState.isAssignableTo(context.getModule(), clazzName);
    }

    <S> S getService(ModuleContext context, ServiceState<S> serviceState) {
        if (serviceState.isUnregistered()) {
            return null;
        }
        serviceState.addUsingModule((AbstractModule)context.getModule());
        S value = serviceState.getScopedValue(context.getModule());
        if (value == null) {
            serviceState.removeUsingModule((AbstractModule)context.getModule());
        }
        return value;
    }

    void unregisterService(ServiceState<?> serviceState) {
        if (serviceState.isUnregistered()) {
            return;
        }
        RuntimeLogger.LOGGER.debug("Unregister service: {}", serviceState);
        for (String className : serviceState.getClassNames()) {
            try {
                List<ServiceState<?>> serviceStates = this.serviceMap.get(className);
                if (serviceStates == null) continue;
                serviceStates.remove(serviceState);
            }
            catch (RuntimeException ex) {
                RuntimeLogger.LOGGER.error("Cannot unregister service: " + className, (Throwable)ex);
            }
        }
        Module serviceOwner = serviceState.getServiceOwner();
        this.frameworkEvents.fireServiceEvent(serviceOwner, 4, serviceState);
        for (AbstractModule module : serviceState.getUsingModulesInternal()) {
            while (this.ungetService(module, serviceState)) {
            }
        }
    }

    boolean ungetService(AbstractModule module, ServiceState<?> serviceState) {
        serviceState.ungetScopedValue((Module)module);
        int useCount = module.removeServiceInUse(serviceState);
        if (useCount == 0) {
            serviceState.removeUsingModule(module);
        }
        return useCount >= 0;
    }
}

