package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata18;
    private final Metadata metadata25;
    private final Metadata metadata21;
    private final Metadata metadata20;
    private final Metadata metadata23;
    private final Metadata metadata15;
    private final Metadata metadata17;
    private final Metadata metadata22;
    private final Metadata metadata24;
    private final Metadata metadata26;
    private final Metadata metadata19;
    private final Metadata metadata27;
    private final Metadata metadata16;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        this.handlebarElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata15)
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata15Template.resolve(mbuiContext.statementContext()), "Logging Configuration"))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata16)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata16Template.resolve(mbuiContext.statementContext()), "Root Logger"))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new Typeahead(
            rootLoggerFormTemplates, mbuiContext.statementContext()));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-categories-form", metadata17)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata17Template.resolve(mbuiContext.statementContext(), name),
                    "Category", name);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new Typeahead(
            loggerFormTemplates, mbuiContext.statementContext()));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-console-form", metadata18)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata18Template.resolve(mbuiContext.statementContext(), name),
                    "Console Handler", name);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            consoleHandlerFormTemplates, mbuiContext.statementContext()));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-file-form", metadata19)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata19Template.resolve(mbuiContext.statementContext(), name),
                    "File Handler", name);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            fileHandlerFormTemplates, mbuiContext.statementContext()));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-rotating-file-form", metadata20)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata20Template.resolve(mbuiContext.statementContext(), name),
                    "Periodic Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicHandlerFormTemplates, mbuiContext.statementContext()));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata21)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata21Template.resolve(mbuiContext.statementContext(), name),
                    "Periodic Size Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicSizeHandlerFormTemplates, mbuiContext.statementContext()));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-size-rotating-file-form", metadata22)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata22Template.resolve(mbuiContext.statementContext(), name),
                    "Size Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            sizeHandlerFormTemplates, mbuiContext.statementContext()));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-async-form", metadata23)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata23Template.resolve(mbuiContext.statementContext(), name),
                    "Async Handler", name);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
            asyncHandlerFormTemplates, mbuiContext.statementContext()));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-custom-form", metadata24)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata24Template.resolve(mbuiContext.statementContext(), name),
                    "Custom Handler", name);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            customHandlerFormTemplates, mbuiContext.statementContext()));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-syslog-form", metadata25)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata25Template.resolve(mbuiContext.statementContext(), name),
                    "Syslog Handler", name);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-custom-form", metadata27)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata27Template.resolve(mbuiContext.statementContext(), name),
                    "Custom Formatter", name);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-pattern-form", metadata26)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata26Template.resolve(mbuiContext.statementContext(), name),
                    "Pattern Formatter", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> loggerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata17)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    IdBuilder.build("logging-categories-table", "add"),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata17,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata17Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Category", name)));
                        });
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new Typeahead(
                    loggerTableTemplates, mbuiContext.statementContext()));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata17Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        loggerTable = new ModelNodeTable<>("logging-categories-table", loggerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> consoleHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata18)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-console-table", "add"), "Console Handler",
                metadata18Template,
                () -> presenter.reload(),
                "level", 
                "target", 
                "formatter"))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata18Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        consoleHandlerTable = new ModelNodeTable<>("logging-handler-console-table", consoleHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> fileHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata19)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-file-table", "add"),
                    metadata19)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata19Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata19Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        fileHandlerTable = new ModelNodeTable<>("logging-handler-file-table", fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata20)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-periodic-rotating-file-table", "add"),
                    metadata20)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata20Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Periodic Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata20Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable<>("logging-handler-periodic-rotating-file-table", periodicHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicSizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata21)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-periodic-size-rotating-file-table", "add"),
                    metadata21)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata21Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Periodic Size Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata21Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable<>("logging-handler-periodic-size-rotating-file-table", periodicSizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> sizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata22)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-size-rotating-file-table", "add"),
                    metadata22)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata22Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Size Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata22Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable<>("logging-handler-size-rotating-file-table", sizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> asyncHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata23)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    IdBuilder.build("logging-handler-async-table", "add"),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata23,
                    asList("level", "subhandlers", "queue-length", "overflow-action"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata23Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Async Handler", name)));
                        });
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
                    asyncHandlerTableTemplates, mbuiContext.statementContext()));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata23Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        asyncHandlerTable = new ModelNodeTable<>("logging-handler-async-table", asyncHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata24)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-custom-table", "add"), "Custom Handler",
                metadata24Template,
                () -> presenter.reload(),
                "level", 
                "module", 
                "class", 
                "formatter"))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata24Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable<>("logging-handler-custom-table", customHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> syslogHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata25)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-syslog-table", "add"), "Syslog Handler",
                metadata25Template,
                () -> presenter.reload(),
                "level", 
                "syslog-format", 
                "hostname", 
                "server-address", 
                "port", 
                "app-name", 
                "facility"))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata25Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable<>("logging-handler-syslog-table", syslogHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata27)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-formatter-custom-table", "add"), "Custom Formatter",
                metadata27Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata27Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFormatterTable = new ModelNodeTable<>("logging-formatter-custom-table", customFormatterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> patternFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata26)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-formatter-pattern-table", "add"), "Pattern Formatter",
                metadata26Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata26Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();
        patternFormatterTable = new ModelNodeTable<>("logging-formatter-pattern-table", patternFormatterTableOptions);

        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        navigation = new VerticalNavigation();
        Elements.Builder loggingConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata15.getDescription().getDescription()}}</p>"))
                    .rememberAs("html42")
                .end()
                .add(loggingConfigForm)
            .end();
        Element loggingConfigItemElement = loggingConfigItemBuilder.build();
        handlebarElements.put("html42", loggingConfigItemBuilder.referenceFor("html42"));
        navigation.addPrimary("logging-config-item", "Configuration", "fa fa-list-ul", loggingConfigItemElement);
        Elements.Builder loggingRootLoggerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">{{metadata16.getDescription().getDescription()}}</p>"))
                    .rememberAs("html44")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingRootLoggerItemElement = loggingRootLoggerItemBuilder.build();
        handlebarElements.put("html44", loggingRootLoggerItemBuilder.referenceFor("html44"));
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        Elements.Builder loggingCategoriesItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata17.getDescription().getDescription()}}</p>"))
                    .rememberAs("html46")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingCategoriesItemElement = loggingCategoriesItemBuilder.build();
        handlebarElements.put("html46", loggingCategoriesItemBuilder.referenceFor("html46"));
        navigation.addPrimary("logging-categories-item", "Categories", "pficon pficon-repository", loggingCategoriesItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingHandlerConsoleItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata18.getDescription().getDescription()}}</p>"))
                    .rememberAs("html49")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingHandlerConsoleItemElement = loggingHandlerConsoleItemBuilder.build();
        handlebarElements.put("html49", loggingHandlerConsoleItemBuilder.referenceFor("html49"));
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        Elements.Builder loggingHandlerFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata19.getDescription().getDescription()}}</p>"))
                    .rememberAs("html52")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingHandlerFileItemElement = loggingHandlerFileItemBuilder.build();
        handlebarElements.put("html52", loggingHandlerFileItemBuilder.referenceFor("html52"));
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        Elements.Builder loggingHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata20.getDescription().getDescription()}}</p>"))
                    .rememberAs("html55")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingHandlerPeriodicRotatingFileItemElement = loggingHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html55", loggingHandlerPeriodicRotatingFileItemBuilder.referenceFor("html55"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata21.getDescription().getDescription()}}</p>"))
                    .rememberAs("html58")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingHandlerPeriodicSizeRotatingFileItemElement = loggingHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html58", loggingHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html58"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata22.getDescription().getDescription()}}</p>"))
                    .rememberAs("html61")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingHandlerSizeRotatingFileItemElement = loggingHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html61", loggingHandlerSizeRotatingFileItemBuilder.referenceFor("html61"));
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerAsyncItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata23.getDescription().getDescription()}}</p>"))
                    .rememberAs("html64")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingHandlerAsyncItemElement = loggingHandlerAsyncItemBuilder.build();
        handlebarElements.put("html64", loggingHandlerAsyncItemBuilder.referenceFor("html64"));
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        Elements.Builder loggingHandlerCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata24.getDescription().getDescription()}}</p>"))
                    .rememberAs("html67")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingHandlerCustomItemElement = loggingHandlerCustomItemBuilder.build();
        handlebarElements.put("html67", loggingHandlerCustomItemBuilder.referenceFor("html67"));
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        Elements.Builder loggingHandlerSyslogItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata25.getDescription().getDescription()}}</p>"))
                    .rememberAs("html70")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingHandlerSyslogItemElement = loggingHandlerSyslogItemBuilder.build();
        handlebarElements.put("html70", loggingHandlerSyslogItemBuilder.referenceFor("html70"));
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingFormatterPatternItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata26.getDescription().getDescription()}}</p>"))
                    .rememberAs("html73")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingFormatterPatternItemElement = loggingFormatterPatternItemBuilder.build();
        handlebarElements.put("html73", loggingFormatterPatternItemBuilder.referenceFor("html73"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        Elements.Builder loggingFormatterCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata27.getDescription().getDescription()}}</p>"))
                    .rememberAs("html76")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingFormatterCustomItemElement = loggingFormatterCustomItemBuilder.build();
        handlebarElements.put("html76", loggingFormatterCustomItemBuilder.referenceFor("html76"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

        loggerTable.api().bindForm(loggerForm);
        consoleHandlerTable.api().bindForm(consoleHandlerForm);
        fileHandlerTable.api().bindForm(fileHandlerForm);
        periodicHandlerTable.api().bindForm(periodicHandlerForm);
        periodicSizeHandlerTable.api().bindForm(periodicSizeHandlerForm);
        sizeHandlerTable.api().bindForm(sizeHandlerForm);
        asyncHandlerTable.api().bindForm(asyncHandlerForm);
        customHandlerTable.api().bindForm(customHandlerForm);
        syslogHandlerTable.api().bindForm(syslogHandlerForm);
        customFormatterTable.api().bindForm(customFormatterForm);
        patternFormatterTable.api().bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html42"), "{{metadata15.getDescription().getDescription()}}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html44"), "{{metadata16.getDescription().getDescription()}}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html46"), "{{metadata17.getDescription().getDescription()}}", String.valueOf(metadata17.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html49"), "{{metadata18.getDescription().getDescription()}}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html52"), "{{metadata19.getDescription().getDescription()}}", String.valueOf(metadata19.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html55"), "{{metadata20.getDescription().getDescription()}}", String.valueOf(metadata20.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html58"), "{{metadata21.getDescription().getDescription()}}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html61"), "{{metadata22.getDescription().getDescription()}}", String.valueOf(metadata22.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html64"), "{{metadata23.getDescription().getDescription()}}", String.valueOf(metadata23.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html67"), "{{metadata24.getDescription().getDescription()}}", String.valueOf(metadata24.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html70"), "{{metadata25.getDescription().getDescription()}}", String.valueOf(metadata25.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html73"), "{{metadata26.getDescription().getDescription()}}", String.valueOf(metadata26.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html76"), "{{metadata27.getDescription().getDescription()}}", String.valueOf(metadata27.getDescription().getDescription()));
    }
}
