package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_PathsView extends PathsView {

    private final Metadata metadata37;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_PathsView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata37Template = AddressTemplate.of("/path=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        this.handlebarElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("path-form", metadata37)
            .include("name", "path", "relative-to")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata37Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        form.getFormItem("relative-to").registerSuggestHandler(new PathsTypeahead());

        Options<org.jboss.hal.dmr.model.NamedNode> tableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata37)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    IdBuilder.build("path-table", "add"),
                    mbuiContext.resources().messages().addResourceTitle("Path"),
                    metadata37,
                    asList("name", "path", "relative-to"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata37Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Path", name)));
                        });
                    });
                dialog.getForm().getFormItem("name").addValidationHandler(new org.jboss.hal.ballroom.form.BlacklistValidation("jboss.home", "user.home", "user.dir", "java.home", "jboss.server.base.dir"));
                dialog.getForm().getFormItem("relative-to").registerSuggestHandler(new PathsTypeahead());
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata37Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        table = new ModelNodeTable<>("path-table", tableOptions);

        registerAttachable(table);
        registerAttachable(form);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .div()
                        .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata37.getDescription().getDescription()}}</p>"))
                        .rememberAs("html105")
                    .end()
                    .add(table)
                    .add(form)
                .end()
            .end();
            handlebarElements.put("html105", layoutBuilder.referenceFor("html105"));

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        table.api().bindForm(form);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html105"), "{{metadata37.getDescription().getDescription()}}", String.valueOf(metadata37.getDescription().getDescription()));
    }
}
