package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final Metadata metadata10;
    private final Metadata metadata6;
    private final Metadata metadata11;
    private final Metadata metadata4;
    private final Metadata metadata3;
    private final Metadata metadata0;
    private final Metadata metadata8;
    private final Metadata metadata7;
    private final Metadata metadata2;
    private final Metadata metadata1;
    private final Metadata metadata9;
    private final Metadata metadata5;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingProfileView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        AddressTemplate metadata0Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata0 = mbuiContext.metadataRegistry().lookup(metadata0Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata2Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        AddressTemplate metadata1Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata1 = mbuiContext.metadataRegistry().lookup(metadata1Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        this.handlebarElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata0)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .build();
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-categories-form", metadata1)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .build();
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-console-form", metadata2)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            consoleHandlerFormTemplates, mbuiContext.statementContext()));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-file-form", metadata3)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            fileHandlerFormTemplates, mbuiContext.statementContext()));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata4)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicHandlerFormTemplates, mbuiContext.statementContext()));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata5)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicSizeHandlerFormTemplates, mbuiContext.statementContext()));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata6)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            sizeHandlerFormTemplates, mbuiContext.statementContext()));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-async-form", metadata7)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
            asyncHandlerFormTemplates, mbuiContext.statementContext()));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-custom-form", metadata8)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            customHandlerFormTemplates, mbuiContext.statementContext()));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-syslog-form", metadata9)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-formatter-custom-form", metadata11)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-formatter-pattern-form", metadata10)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> loggerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata1)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addLogger())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeLogger(api))
            .columns("category", "level")
            .build();
        loggerTable = new ModelNodeTable<>("logging-profile-categories-table", loggerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> consoleHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata2)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addConsoleHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeConsoleHandler(api))
            .columns("name", "level", "target")
            .build();
        consoleHandlerTable = new ModelNodeTable<>("logging-profile-handler-console-table", consoleHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> fileHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata3)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addFileHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeFileHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        fileHandlerTable = new ModelNodeTable<>("logging-profile-handler-file-table", fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata4)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPeriodicHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePeriodicHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable<>("logging-profile-handler-periodic-rotating-file-table", periodicHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicSizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata5)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPeriodicSizeHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePeriodicSizeHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable<>("logging-profile-handler-periodic-size-rotating-file-table", periodicSizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> sizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata6)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addSizeHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeSizeHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable<>("logging-profile-handler-size-rotating-file-table", sizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> asyncHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata7)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addAsyncHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeAsyncHandler(api))
            .columns("name", "level")
            .build();
        asyncHandlerTable = new ModelNodeTable<>("logging-profile-handler-async-table", asyncHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata8)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addCustomHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeCustomHandler(api))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable<>("logging-profile-handler-custom-table", customHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> syslogHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata9)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addSyslogHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeSyslogHandler(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable<>("logging-profile-handler-syslog-table", syslogHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata11)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addCustomFormatter())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeCustomFormatter(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFormatterTable = new ModelNodeTable<>("logging-profile-formatter-custom-table", customFormatterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> patternFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata10)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPatternFormatter())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePatternFormatter(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();
        patternFormatterTable = new ModelNodeTable<>("logging-profile-formatter-pattern-table", patternFormatterTableOptions);

        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        navigation = new VerticalNavigation();
        Elements.Builder loggingProfileRootLoggerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">{{metadata0.getDescription().getDescription()}}</p>"))
                    .rememberAs("html0")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingProfileRootLoggerItemElement = loggingProfileRootLoggerItemBuilder.build();
        handlebarElements.put("html0", loggingProfileRootLoggerItemBuilder.referenceFor("html0"));
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        Elements.Builder loggingProfileCategoriesItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata1.getDescription().getDescription()}}</p>"))
                    .rememberAs("html2")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingProfileCategoriesItemElement = loggingProfileCategoriesItemBuilder.build();
        handlebarElements.put("html2", loggingProfileCategoriesItemBuilder.referenceFor("html2"));
        navigation.addPrimary("logging-profile-categories-item", "Categories", "pficon pficon-repository", loggingProfileCategoriesItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingProfileHandlerConsoleItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata2.getDescription().getDescription()}}</p>"))
                    .rememberAs("html5")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingProfileHandlerConsoleItemElement = loggingProfileHandlerConsoleItemBuilder.build();
        handlebarElements.put("html5", loggingProfileHandlerConsoleItemBuilder.referenceFor("html5"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        Elements.Builder loggingProfileHandlerFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata3.getDescription().getDescription()}}</p>"))
                    .rememberAs("html8")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingProfileHandlerFileItemElement = loggingProfileHandlerFileItemBuilder.build();
        handlebarElements.put("html8", loggingProfileHandlerFileItemBuilder.referenceFor("html8"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata4.getDescription().getDescription()}}</p>"))
                    .rememberAs("html11")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicRotatingFileItemElement = loggingProfileHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html11", loggingProfileHandlerPeriodicRotatingFileItemBuilder.referenceFor("html11"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata5.getDescription().getDescription()}}</p>"))
                    .rememberAs("html14")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicSizeRotatingFileItemElement = loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html14", loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html14"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata6.getDescription().getDescription()}}</p>"))
                    .rememberAs("html17")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingProfileHandlerSizeRotatingFileItemElement = loggingProfileHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html17", loggingProfileHandlerSizeRotatingFileItemBuilder.referenceFor("html17"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerAsyncItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata7.getDescription().getDescription()}}</p>"))
                    .rememberAs("html20")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingProfileHandlerAsyncItemElement = loggingProfileHandlerAsyncItemBuilder.build();
        handlebarElements.put("html20", loggingProfileHandlerAsyncItemBuilder.referenceFor("html20"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        Elements.Builder loggingProfileHandlerCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata8.getDescription().getDescription()}}</p>"))
                    .rememberAs("html23")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingProfileHandlerCustomItemElement = loggingProfileHandlerCustomItemBuilder.build();
        handlebarElements.put("html23", loggingProfileHandlerCustomItemBuilder.referenceFor("html23"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        Elements.Builder loggingProfileHandlerSyslogItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata9.getDescription().getDescription()}}</p>"))
                    .rememberAs("html26")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingProfileHandlerSyslogItemElement = loggingProfileHandlerSyslogItemBuilder.build();
        handlebarElements.put("html26", loggingProfileHandlerSyslogItemBuilder.referenceFor("html26"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingProfileFormatterPatternItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata10.getDescription().getDescription()}}</p>"))
                    .rememberAs("html29")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingProfileFormatterPatternItemElement = loggingProfileFormatterPatternItemBuilder.build();
        handlebarElements.put("html29", loggingProfileFormatterPatternItemBuilder.referenceFor("html29"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        Elements.Builder loggingProfileFormatterCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata11.getDescription().getDescription()}}</p>"))
                    .rememberAs("html32")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingProfileFormatterCustomItemElement = loggingProfileFormatterCustomItemBuilder.build();
        handlebarElements.put("html32", loggingProfileFormatterCustomItemBuilder.referenceFor("html32"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

        loggerTable.api().bindForm(loggerForm);
        consoleHandlerTable.api().bindForm(consoleHandlerForm);
        fileHandlerTable.api().bindForm(fileHandlerForm);
        periodicHandlerTable.api().bindForm(periodicHandlerForm);
        periodicSizeHandlerTable.api().bindForm(periodicSizeHandlerForm);
        sizeHandlerTable.api().bindForm(sizeHandlerForm);
        asyncHandlerTable.api().bindForm(asyncHandlerForm);
        customHandlerTable.api().bindForm(customHandlerForm);
        syslogHandlerTable.api().bindForm(syslogHandlerForm);
        customFormatterTable.api().bindForm(customFormatterForm);
        patternFormatterTable.api().bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html0"), "{{metadata0.getDescription().getDescription()}}", String.valueOf(metadata0.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html2"), "{{metadata1.getDescription().getDescription()}}", String.valueOf(metadata1.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html5"), "{{metadata2.getDescription().getDescription()}}", String.valueOf(metadata2.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html8"), "{{metadata3.getDescription().getDescription()}}", String.valueOf(metadata3.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html11"), "{{metadata4.getDescription().getDescription()}}", String.valueOf(metadata4.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html14"), "{{metadata5.getDescription().getDescription()}}", String.valueOf(metadata5.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html17"), "{{metadata6.getDescription().getDescription()}}", String.valueOf(metadata6.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html20"), "{{metadata7.getDescription().getDescription()}}", String.valueOf(metadata7.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html23"), "{{metadata8.getDescription().getDescription()}}", String.valueOf(metadata8.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html26"), "{{metadata9.getDescription().getDescription()}}", String.valueOf(metadata9.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html29"), "{{metadata10.getDescription().getDescription()}}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html32"), "{{metadata11.getDescription().getDescription()}}", String.valueOf(metadata11.getDescription().getDescription()));
    }
}
