package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata26;
    private final Metadata metadata33;
    private final Metadata metadata29;
    private final Metadata metadata28;
    private final Metadata metadata31;
    private final Metadata metadata23;
    private final Metadata metadata25;
    private final Metadata metadata30;
    private final Metadata metadata32;
    private final Metadata metadata34;
    private final Metadata metadata27;
    private final Metadata metadata35;
    private final Metadata metadata24;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        this.handlebarElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata23)
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata23Template.resolve(mbuiContext.statementContext()), "Logging Configuration"))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata24)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata24Template.resolve(mbuiContext.statementContext()), "Root Logger"))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new Typeahead(
            rootLoggerFormTemplates, mbuiContext.statementContext()));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-categories-form", metadata25)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata25Template.resolve(mbuiContext.statementContext(), name),
                    "Category", name);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new Typeahead(
            loggerFormTemplates, mbuiContext.statementContext()));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-console-form", metadata26)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata26Template.resolve(mbuiContext.statementContext(), name),
                    "Console Handler", name);
            })
            .build();
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-file-form", metadata27)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata27Template.resolve(mbuiContext.statementContext(), name),
                    "File Handler", name);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            fileHandlerFormTemplates, mbuiContext.statementContext()));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-rotating-file-form", metadata28)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata28Template.resolve(mbuiContext.statementContext(), name),
                    "Periodic Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicHandlerFormTemplates, mbuiContext.statementContext()));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata29)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata29Template.resolve(mbuiContext.statementContext(), name),
                    "Periodic Size Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicSizeHandlerFormTemplates, mbuiContext.statementContext()));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-size-rotating-file-form", metadata30)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata30Template.resolve(mbuiContext.statementContext(), name),
                    "Size Rotating File Handler", name);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            sizeHandlerFormTemplates, mbuiContext.statementContext()));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-async-form", metadata31)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata31Template.resolve(mbuiContext.statementContext(), name),
                    "Async Handler", name);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
            asyncHandlerFormTemplates, mbuiContext.statementContext()));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-custom-form", metadata32)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata32Template.resolve(mbuiContext.statementContext(), name),
                    "Custom Handler", name);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            customHandlerFormTemplates, mbuiContext.statementContext()));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-syslog-form", metadata33)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata33Template.resolve(mbuiContext.statementContext(), name),
                    "Syslog Handler", name);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-custom-form", metadata35)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata35Template.resolve(mbuiContext.statementContext(), name),
                    "Custom Formatter", name);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-pattern-form", metadata34)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata34Template.resolve(mbuiContext.statementContext(), name),
                    "Pattern Formatter", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> loggerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata25)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    IdBuilder.build("logging-categories-table", "add"),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata25,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata25Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Category", name)));
                        });
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new Typeahead(
                    loggerTableTemplates, mbuiContext.statementContext()));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata25Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        loggerTable = new ModelNodeTable<>("logging-categories-table", loggerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> consoleHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata26)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-console-table", "add"), "Console Handler",
                metadata26Template,
                () -> presenter.reload(),
                "level", 
                "target", 
                "formatter"))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata26Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        consoleHandlerTable = new ModelNodeTable<>("logging-handler-console-table", consoleHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> fileHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata27)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-file-table", "add"),
                    metadata27)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata27Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata27Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        fileHandlerTable = new ModelNodeTable<>("logging-handler-file-table", fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata28)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-periodic-rotating-file-table", "add"),
                    metadata28)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata28Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Periodic Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata28Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable<>("logging-handler-periodic-rotating-file-table", periodicHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicSizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata29)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-periodic-size-rotating-file-table", "add"),
                    metadata29)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata29Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Periodic Size Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata29Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable<>("logging-handler-periodic-size-rotating-file-table", periodicSizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> sizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata30)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(IdBuilder.build("logging-handler-size-rotating-file-table", "add"),
                    metadata30)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", (attributeDescription) -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata30Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                            mbuiContext.resources().messages().addResourceSuccess("Size Rotating File Handler", name)));
                        });
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata30Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable<>("logging-handler-size-rotating-file-table", sizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> asyncHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata31)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    IdBuilder.build("logging-handler-async-table", "add"),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata31,
                    asList("level", "subhandlers", "queue-length", "overflow-action"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata31Template.resolve(mbuiContext.statementContext(), name);
                        Operation operation = new Operation.Builder(ADD, address).payload(modelNode).build();
                        mbuiContext.dispatcher().execute(operation, result -> {
                            presenter.reload();
                            MessageEvent.fire(mbuiContext.eventBus(), Message.success(
                                mbuiContext.resources().messages().addResourceSuccess("Async Handler", name)));
                        });
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
                    asyncHandlerTableTemplates, mbuiContext.statementContext()));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata31Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        asyncHandlerTable = new ModelNodeTable<>("logging-handler-async-table", asyncHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata32)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-custom-table", "add"), "Custom Handler",
                metadata32Template,
                () -> presenter.reload(),
                "level", 
                "module", 
                "class", 
                "formatter"))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata32Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable<>("logging-handler-custom-table", customHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> syslogHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata33)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-handler-syslog-table", "add"), "Syslog Handler",
                metadata33Template,
                () -> presenter.reload(),
                "level", 
                "syslog-format", 
                "hostname", 
                "server-address", 
                "port", 
                "app-name", 
                "facility"))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata33Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable<>("logging-handler-syslog-table", syslogHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata35)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-formatter-custom-table", "add"), "Custom Formatter",
                metadata35Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata35Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFormatterTable = new ModelNodeTable<>("logging-formatter-custom-table", customFormatterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> patternFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata34)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("logging-formatter-pattern-table", "add"), "Pattern Formatter",
                metadata34Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata34Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();
        patternFormatterTable = new ModelNodeTable<>("logging-formatter-pattern-table", patternFormatterTableOptions);

        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        navigation = new VerticalNavigation();
        Elements.Builder loggingConfigItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata23.getDescription().getDescription()}}</p>"))
                    .rememberAs("html65")
                .end()
                .add(loggingConfigForm)
            .end();
        Element loggingConfigItemElement = loggingConfigItemBuilder.build();
        handlebarElements.put("html65", loggingConfigItemBuilder.referenceFor("html65"));
        navigation.addPrimary("logging-config-item", "Configuration", "fa fa-list-ul", loggingConfigItemElement);
        Elements.Builder loggingRootLoggerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">{{metadata24.getDescription().getDescription()}}</p>"))
                    .rememberAs("html67")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingRootLoggerItemElement = loggingRootLoggerItemBuilder.build();
        handlebarElements.put("html67", loggingRootLoggerItemBuilder.referenceFor("html67"));
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        Elements.Builder loggingCategoriesItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata25.getDescription().getDescription()}}</p>"))
                    .rememberAs("html69")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingCategoriesItemElement = loggingCategoriesItemBuilder.build();
        handlebarElements.put("html69", loggingCategoriesItemBuilder.referenceFor("html69"));
        navigation.addPrimary("logging-categories-item", "Categories", "pficon pficon-repository", loggingCategoriesItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingHandlerConsoleItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata26.getDescription().getDescription()}}</p>"))
                    .rememberAs("html72")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingHandlerConsoleItemElement = loggingHandlerConsoleItemBuilder.build();
        handlebarElements.put("html72", loggingHandlerConsoleItemBuilder.referenceFor("html72"));
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        Elements.Builder loggingHandlerFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata27.getDescription().getDescription()}}</p>"))
                    .rememberAs("html75")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingHandlerFileItemElement = loggingHandlerFileItemBuilder.build();
        handlebarElements.put("html75", loggingHandlerFileItemBuilder.referenceFor("html75"));
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        Elements.Builder loggingHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata28.getDescription().getDescription()}}</p>"))
                    .rememberAs("html78")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingHandlerPeriodicRotatingFileItemElement = loggingHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html78", loggingHandlerPeriodicRotatingFileItemBuilder.referenceFor("html78"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata29.getDescription().getDescription()}}</p>"))
                    .rememberAs("html81")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingHandlerPeriodicSizeRotatingFileItemElement = loggingHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html81", loggingHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html81"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata30.getDescription().getDescription()}}</p>"))
                    .rememberAs("html84")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingHandlerSizeRotatingFileItemElement = loggingHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html84", loggingHandlerSizeRotatingFileItemBuilder.referenceFor("html84"));
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerAsyncItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata31.getDescription().getDescription()}}</p>"))
                    .rememberAs("html87")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingHandlerAsyncItemElement = loggingHandlerAsyncItemBuilder.build();
        handlebarElements.put("html87", loggingHandlerAsyncItemBuilder.referenceFor("html87"));
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        Elements.Builder loggingHandlerCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata32.getDescription().getDescription()}}</p>"))
                    .rememberAs("html90")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingHandlerCustomItemElement = loggingHandlerCustomItemBuilder.build();
        handlebarElements.put("html90", loggingHandlerCustomItemBuilder.referenceFor("html90"));
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        Elements.Builder loggingHandlerSyslogItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata33.getDescription().getDescription()}}</p>"))
                    .rememberAs("html93")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingHandlerSyslogItemElement = loggingHandlerSyslogItemBuilder.build();
        handlebarElements.put("html93", loggingHandlerSyslogItemBuilder.referenceFor("html93"));
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingFormatterPatternItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata34.getDescription().getDescription()}}</p>"))
                    .rememberAs("html96")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingFormatterPatternItemElement = loggingFormatterPatternItemBuilder.build();
        handlebarElements.put("html96", loggingFormatterPatternItemBuilder.referenceFor("html96"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        Elements.Builder loggingFormatterCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata35.getDescription().getDescription()}}</p>"))
                    .rememberAs("html99")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingFormatterCustomItemElement = loggingFormatterCustomItemBuilder.build();
        handlebarElements.put("html99", loggingFormatterCustomItemBuilder.referenceFor("html99"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

        loggerTable.api().bindForm(loggerForm);
        consoleHandlerTable.api().bindForm(consoleHandlerForm);
        fileHandlerTable.api().bindForm(fileHandlerForm);
        periodicHandlerTable.api().bindForm(periodicHandlerForm);
        periodicSizeHandlerTable.api().bindForm(periodicSizeHandlerForm);
        sizeHandlerTable.api().bindForm(sizeHandlerForm);
        asyncHandlerTable.api().bindForm(asyncHandlerForm);
        customHandlerTable.api().bindForm(customHandlerForm);
        syslogHandlerTable.api().bindForm(syslogHandlerForm);
        customFormatterTable.api().bindForm(customFormatterForm);
        patternFormatterTable.api().bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html65"), "{{metadata23.getDescription().getDescription()}}", String.valueOf(metadata23.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html67"), "{{metadata24.getDescription().getDescription()}}", String.valueOf(metadata24.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html69"), "{{metadata25.getDescription().getDescription()}}", String.valueOf(metadata25.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html72"), "{{metadata26.getDescription().getDescription()}}", String.valueOf(metadata26.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html75"), "{{metadata27.getDescription().getDescription()}}", String.valueOf(metadata27.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html78"), "{{metadata28.getDescription().getDescription()}}", String.valueOf(metadata28.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html81"), "{{metadata29.getDescription().getDescription()}}", String.valueOf(metadata29.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html84"), "{{metadata30.getDescription().getDescription()}}", String.valueOf(metadata30.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html87"), "{{metadata31.getDescription().getDescription()}}", String.valueOf(metadata31.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html90"), "{{metadata32.getDescription().getDescription()}}", String.valueOf(metadata32.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html93"), "{{metadata33.getDescription().getDescription()}}", String.valueOf(metadata33.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html96"), "{{metadata34.getDescription().getDescription()}}", String.valueOf(metadata34.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html99"), "{{metadata35.getDescription().getDescription()}}", String.valueOf(metadata35.getDescription().getDescription()));
    }
}
